/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.sanger.artemis.plot;

import uk.ac.sanger.artemis.io.Range;
import uk.ac.sanger.artemis.plot.BaseAlgorithm;
import uk.ac.sanger.artemis.sequence.Strand;
import uk.ac.sanger.artemis.util.OutOfRangeException;

public class ATDeviationAlgorithm
extends BaseAlgorithm {
    public ATDeviationAlgorithm(Strand strand) {
        super(strand, "AT Deviation (A-T)/(A+T)", "at_deviation");
        this.setScalingFlag(true);
    }

    public void getValues(int start, int end, float[] values) {
        String sequence;
        try {
            sequence = this.getStrand().getSubSequence(new Range(start, end));
        }
        catch (OutOfRangeException e) {
            throw new Error("internal error - unexpected exception: " + e);
        }
        float a_count = 0.0f;
        float t_count = 0.0f;
        int i = 0;
        while (i < sequence.length()) {
            char this_char = sequence.charAt(i);
            if (this_char == 'a') {
                a_count += 1.0f;
            }
            if (this_char == 't') {
                t_count += 1.0f;
            }
            ++i;
        }
        values[0] = a_count + t_count > 0.0f ? (a_count - t_count) / (a_count + t_count) : 0.0f;
    }

    public int getValueCount() {
        return 1;
    }

    public Integer getDefaultWindowSize() {
        Integer super_window_size = super.getDefaultWindowSize();
        if (super_window_size != null) {
            return super_window_size;
        }
        return new Integer(30);
    }

    public Integer getDefaultMaxWindowSize() {
        Integer super_max_window_size = super.getDefaultMaxWindowSize();
        if (super_max_window_size != null) {
            return super_max_window_size;
        }
        return new Integer(5000);
    }

    public Integer getDefaultMinWindowSize() {
        Integer super_min_window_size = super.getDefaultMinWindowSize();
        if (super_min_window_size != null) {
            return super_min_window_size;
        }
        return new Integer(10);
    }

    public Integer getDefaultStepSize(int window_size) {
        if (window_size > 10) {
            return new Integer(window_size / 10);
        }
        return null;
    }

    protected Float getMaximumInternal() {
        return new Float(1.0f);
    }

    protected Float getMinimumInternal() {
        return new Float(-1.0f);
    }

    public Float getAverage() {
        float a_count = this.getStrand().getACount();
        float t_count = this.getStrand().getTCount();
        float a_minus_t = a_count - t_count;
        float a_plus_t = a_count + t_count;
        if (a_plus_t > 0.0f) {
            return new Float(a_minus_t / a_plus_t);
        }
        return new Float(0.0);
    }
}

