/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.sanger.artemis.plot;

import uk.ac.sanger.artemis.Feature;
import uk.ac.sanger.artemis.plot.FeatureAlgorithm;

public abstract class HydroAlgorithm
extends FeatureAlgorithm {
    private float[] data_array;
    private static final String amino_acid_array = "rkdqnehstpycgamwlvfi";

    public HydroAlgorithm(Feature feature, String algorithm_name, String algorithm_short_name, float[] data_array) {
        super(feature, algorithm_name, algorithm_short_name);
        this.data_array = data_array;
    }

    public void getValues(int start, int end, float[] values) {
        String translation = this.getFeature().getTranslation().toString().substring(start, end);
        float total = 0.0f;
        int i = 0;
        while (i < translation.length()) {
            total += this.getCodonValue(this.data_array, translation.charAt(i));
            ++i;
        }
        values[0] = total / (float)translation.length();
    }

    public Integer getDefaultWindowSize() {
        Integer super_window_size = super.getDefaultWindowSize();
        if (super_window_size != null) {
            return super_window_size;
        }
        return new Integer(7);
    }

    public Integer getDefaultMaxWindowSize() {
        Integer super_max_window_size = super.getDefaultMaxWindowSize();
        if (super_max_window_size != null) {
            return super_max_window_size;
        }
        return new Integer(100);
    }

    public Integer getDefaultMinWindowSize() {
        Integer super_min_window_size = super.getDefaultMinWindowSize();
        if (super_min_window_size != null) {
            return super_min_window_size;
        }
        return new Integer(7);
    }

    public Integer getDefaultStepSize(int window_size) {
        return new Integer(1);
    }

    public Float getAverage() {
        return new Float(0.0f);
    }

    private float getCodonValue(float[] data_array, char amino_acid_symbol) {
        int index = amino_acid_array.indexOf(amino_acid_symbol);
        if (index == -1) {
            return 0.0f;
        }
        return data_array[index];
    }
}

