/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.sanger.artemis.sequence;

import java.util.Vector;
import uk.ac.sanger.artemis.sequence.MarkerChangeEvent;
import uk.ac.sanger.artemis.sequence.MarkerChangeListener;
import uk.ac.sanger.artemis.sequence.MarkerInternal;
import uk.ac.sanger.artemis.sequence.Strand;
import uk.ac.sanger.artemis.util.OutOfRangeException;

public class Marker {
    public static final int LISTENER_PRIORITY = 0;
    private MarkerInternal markerinternal;
    private final Vector marker_listener_list = new Vector();

    Marker(Strand strand, int position) throws OutOfRangeException {
        this.markerinternal = new MarkerInternal(strand, position);
        strand.getBases().addSequenceChangeListener(this.markerinternal, 0);
    }

    public Strand getStrand() {
        return this.getInternal().getStrand();
    }

    public int getPosition() {
        return this.getInternal().getPosition();
    }

    public void setPosition(int position) throws OutOfRangeException {
        this.getInternal().setPosition(position);
    }

    public int getRawPosition() {
        return this.getStrand().getRawPosition(this.getPosition());
    }

    public void setRawPosition(int position) throws OutOfRangeException {
        this.getInternal().setPosition(this.getStrand().getRawPosition(position));
    }

    public boolean equals(Marker test_marker) {
        return test_marker.getPosition() == this.getPosition() && test_marker.getStrand() == this.getStrand();
    }

    public void addMarkerChangeListener(MarkerChangeListener l) {
        if (this.marker_listener_list.size() == 0) {
            this.getInternal().parent = this;
        }
        this.marker_listener_list.addElement(l);
    }

    public void removeMarkerChangeListener(MarkerChangeListener l) {
        this.marker_listener_list.removeElement(l);
        if (this.marker_listener_list.size() == 0) {
            this.getInternal().parent = null;
        }
    }

    public static Marker getRawLowest(Marker marker_1, Marker marker_2) {
        if (marker_1.getRawPosition() <= marker_2.getRawPosition()) {
            return marker_1;
        }
        return marker_2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireEvent(MarkerChangeEvent event) {
        Vector targets;
        Marker marker = this;
        synchronized (marker) {
            targets = (Vector)this.marker_listener_list.clone();
        }
        int i = 0;
        while (i < targets.size()) {
            MarkerChangeListener target = (MarkerChangeListener)targets.elementAt(i);
            target.markerChanged(event);
            ++i;
        }
    }

    public Marker moveBy(int offset) throws OutOfRangeException {
        return new Marker(this.getStrand(), this.getPosition() + offset);
    }

    public void finalize() {
        this.getStrand().getBases().removeSequenceChangeListener(this.markerinternal);
    }

    private MarkerInternal getInternal() {
        return this.markerinternal;
    }
}

