/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.sanger.artemis.util;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import uk.ac.sanger.artemis.util.InputStreamProgressListener;
import uk.ac.sanger.artemis.util.InputStreamProgressListenerVector;
import uk.ac.sanger.artemis.util.LinePushBackReader;

public abstract class Document {
    private Object location = null;
    private LinePushBackReader line_push_push_reader = null;
    private final InputStreamProgressListenerVector listeners = new InputStreamProgressListenerVector();

    public Document(Document directory_document, String name) throws IOException {
        this.location = directory_document.append(name).getLocation();
    }

    public abstract Document append(String var1) throws IOException;

    public abstract String getName();

    public abstract Document getParent();

    public abstract boolean readable();

    public abstract boolean writable();

    public abstract InputStream getInputStream() throws IOException;

    public Reader getReader() throws IOException {
        return new InputStreamReader(this.getInputStream());
    }

    public LinePushBackReader getLinePushBackReader() throws IOException {
        if (this.line_push_push_reader == null) {
            this.line_push_push_reader = new LinePushBackReader(new InputStreamReader(this.getInputStream()));
        }
        return this.line_push_push_reader;
    }

    public void addInputStreamProgressListener(InputStreamProgressListener listener) {
        this.listeners.add(listener);
    }

    protected InputStreamProgressListenerVector getProgressListeners() {
        return this.listeners;
    }

    public abstract OutputStream getOutputStream() throws IOException;

    public Writer getWriter() throws IOException {
        return new BufferedWriter(new OutputStreamWriter(this.getOutputStream()), 100000);
    }

    public String toString() {
        return this.getLocation().toString();
    }

    protected Document(Object location) {
        if (location == null) {
            throw new Error("internal error - created a null Document");
        }
        this.location = location;
    }

    protected Object getLocation() {
        return this.location;
    }
}

