/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.sanger.artemis.util;

import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Reader;
import uk.ac.sanger.artemis.util.PushBackException;

public class LinePushBackReader
extends Reader {
    private String line_buffer;
    private LineNumberReader buffered_reader;

    public LinePushBackReader(Reader in_stream) {
        this.buffered_reader = new LineNumberReader(in_stream);
    }

    public String readLine() throws IOException {
        if (this.line_buffer != null) {
            String tmp_string = this.line_buffer;
            this.line_buffer = null;
            return tmp_string;
        }
        String line = this.buffered_reader.readLine();
        return line;
    }

    public int getLineNumber() {
        return this.buffered_reader.getLineNumber();
    }

    public int read(char[] cbuf, int off, int len) throws IOException {
        return this.buffered_reader.read(cbuf, off, len);
    }

    public void close() throws IOException {
        this.buffered_reader.close();
    }

    public void pushBack(String line) throws PushBackException {
        if (this.line_buffer != null) {
            throw new PushBackException("LinePushBackReader.pushBack () called twice before calling readLine ()");
        }
        this.line_buffer = line;
    }
}

