/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.externaltools.internal.model;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.externaltools.internal.model.ExternalToolsModelMessages;
import org.eclipse.ui.externaltools.internal.model.ExternalToolsPlugin;
import org.eclipse.ui.externaltools.internal.registry.ExternalToolMigration;

public class BuilderUtils {
    public static final String LAUNCH_CONFIG_HANDLE = "LaunchConfigHandle";
    public static final String BUILDER_FOLDER_NAME = ".externalToolBuilders";
    public static final String PROJECT_TAG = "<project>";
    public static final String VERSION_1_0 = "1.0";
    public static final String VERSION_2_1 = "2.1";
    public static final String VERSION_3_0_interim = "3.0.interim";
    public static final String VERSION_3_0_final = "3.0";
    private static final String TAG_CONFIGURATION_MAP = "configurationMap";
    private static final String TAG_SOURCE_TYPE = "sourceType";
    private static final String TAG_BUILDER_TYPE = "builderType";

    public static ILaunchConfiguration configFromBuildCommandArgs(IProject project, Map commandArgs, String[] version) {
        String configHandle = (String)commandArgs.get(LAUNCH_CONFIG_HANDLE);
        if (configHandle == null) {
            version[0] = VERSION_1_0;
            return ExternalToolMigration.configFromArgumentMap(commandArgs);
        }
        ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfiguration configuration = null;
        if (configHandle.startsWith(PROJECT_TAG)) {
            version[0] = VERSION_3_0_final;
            Path path = new Path(configHandle);
            IFile file = project.getFile(path.removeFirstSegments(1));
            if (file.exists()) {
                configuration = manager.getLaunchConfiguration(file);
            }
        } else {
            IPath path = new Path(BUILDER_FOLDER_NAME).append(configHandle);
            IFile file = project.getFile(path);
            if (file.exists()) {
                version[0] = VERSION_3_0_interim;
                configuration = manager.getLaunchConfiguration(file);
            } else {
                try {
                    configuration = manager.getLaunchConfiguration(configHandle);
                }
                catch (CoreException coreException) {}
                if (configuration != null) {
                    version[0] = VERSION_2_1;
                }
            }
        }
        return configuration;
    }

    public static ICommand commandFromLaunchConfig(IProject project, ILaunchConfiguration config) {
        ICommand newCommand = null;
        try {
            newCommand = project.getDescription().newCommand();
            newCommand = BuilderUtils.toBuildCommand(project, config, newCommand);
        }
        catch (CoreException coreException) {
            Shell shell = ExternalToolsPlugin.getActiveWorkbenchShell();
            if (shell != null) {
                MessageDialog.openError((Shell)shell, (String)ExternalToolsModelMessages.getString("BuilderUtils.5"), (String)ExternalToolsModelMessages.getString("BuilderUtils.6"));
            }
            return null;
        }
        return newCommand;
    }

    public static boolean isUnmigratedConfig(ILaunchConfiguration config) {
        return config.isWorkingCopy() && ((ILaunchConfigurationWorkingCopy)config).getOriginal() == null;
    }

    public static ICommand toBuildCommand(IProject project, ILaunchConfiguration config, ICommand command) throws CoreException {
        Map<String, String> args = null;
        if (BuilderUtils.isUnmigratedConfig(config)) {
            ICommand[] commands = project.getDescription().getBuildSpec();
            int i = 0;
            while (i < commands.length) {
                ICommand projectCommand = commands[i];
                String name = ExternalToolMigration.getNameFromCommandArgs(projectCommand.getArguments());
                if (name != null && name.equals(config.getName())) {
                    args = projectCommand.getArguments();
                    break;
                }
                ++i;
            }
        } else {
            ILaunchConfigurationWorkingCopy workingCopy;
            if (config instanceof ILaunchConfigurationWorkingCopy && (workingCopy = (ILaunchConfigurationWorkingCopy)config).getOriginal() != null) {
                config = workingCopy.getOriginal();
            }
            args = new HashMap<String, String>();
            StringBuffer buffer = new StringBuffer(PROJECT_TAG);
            buffer.append('/').append(config.getFile().getFullPath().removeFirstSegments(1));
            args.put(LAUNCH_CONFIG_HANDLE, buffer.toString());
        }
        command.setBuilderName("org.eclipse.ui.externaltools.ExternalToolBuilder");
        command.setArguments(args);
        return command;
    }

    public static ILaunchConfigurationType getConfigurationDuplicationType(ILaunchConfiguration config) throws CoreException {
        ILaunchConfigurationType type;
        IExtensionPoint ep = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.ui.externaltools", "configurationDuplicationMaps");
        IConfigurationElement[] elements = ep.getConfigurationElements();
        String sourceType = config.getType().getIdentifier();
        String builderType = null;
        int i = 0;
        while (i < elements.length) {
            IConfigurationElement element = elements[i];
            if (element.getName().equals(TAG_CONFIGURATION_MAP) && sourceType.equals(element.getAttribute(TAG_SOURCE_TYPE))) {
                builderType = element.getAttribute(TAG_BUILDER_TYPE);
                break;
            }
            ++i;
        }
        if (builderType != null && (type = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurationType(builderType)) != null) {
            return type;
        }
        return config.getType();
    }

    public static IFolder getBuilderFolder(IProject project, boolean create) {
        IFolder folder = project.getFolder(BUILDER_FOLDER_NAME);
        if (!folder.exists() && create) {
            try {
                folder.create(true, true, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException coreException) {
                return null;
            }
        }
        return folder;
    }

    public static ILaunchConfiguration duplicateConfiguration(IProject project, ILaunchConfiguration config) throws CoreException {
        Map attributes = null;
        attributes = config.getAttributes();
        String newName = config.getName() + ExternalToolsModelMessages.getString("BuilderUtils.7");
        newName = DebugPlugin.getDefault().getLaunchManager().generateUniqueLaunchConfigurationNameFrom(newName);
        ILaunchConfigurationType newType = BuilderUtils.getConfigurationDuplicationType(config);
        ILaunchConfigurationWorkingCopy newWorkingCopy = newType.newInstance((IContainer)BuilderUtils.getBuilderFolder(project, true), newName);
        newWorkingCopy.setAttributes(attributes);
        return newWorkingCopy.doSave();
    }

    public static ILaunchConfiguration migrateBuilderConfiguration(IProject project, ILaunchConfigurationWorkingCopy workingCopy) throws CoreException {
        IStatus status;
        workingCopy.setContainer((IContainer)BuilderUtils.getBuilderFolder(project, true));
        String name = workingCopy.getName();
        name = name.replace('/', '.');
        if (name.charAt(0) == '.') {
            name = name.substring(1);
        }
        if (!(status = ResourcesPlugin.getWorkspace().validateName(name, 1)).isOK()) {
            name = "ExternalTool";
        }
        name = DebugPlugin.getDefault().getLaunchManager().generateUniqueLaunchConfigurationNameFrom(name);
        workingCopy.rename(name);
        return workingCopy.doSave();
    }
}

