/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.program.abi;

import java.util.ArrayList;
import java.util.Iterator;
import org.biojava.bio.BioError;
import org.biojava.bio.seq.DNATools;
import org.biojava.bio.seq.io.CharacterTokenization;
import org.biojava.bio.seq.io.SymbolTokenization;
import org.biojava.bio.symbol.AbstractAlphabet;
import org.biojava.bio.symbol.Alignment;
import org.biojava.bio.symbol.AlphabetManager;
import org.biojava.bio.symbol.AtomicSymbol;
import org.biojava.bio.symbol.FiniteAlphabet;
import org.biojava.bio.symbol.IllegalAlphabetException;
import org.biojava.bio.symbol.IntegerAlphabet;
import org.biojava.bio.symbol.Symbol;
import org.biojava.bio.symbol.SymbolList;
import org.biojava.bio.symbol.SymbolListViews;
import org.biojava.utils.ListTools;

public class ABITools {
    public static final FiniteAlphabet QUALITY;
    public static final AtomicSymbol _0;
    public static final AtomicSymbol _1;
    public static final Object SEQUENCE;
    public static final Object SUPPORT;

    public static Alignment getAlignment(SymbolList abiSeq) throws IllegalAlphabetException {
        return SymbolListViews.alignment(new ListTools.Doublet(SEQUENCE, SUPPORT), abiSeq);
    }

    static {
        SEQUENCE = "SEQUENCE";
        SUPPORT = "SUPPORT";
        try {
            IntegerAlphabet.SubIntegerAlphabet _01 = IntegerAlphabet.getSubAlphabet(0, 1);
            _0 = _01.getSymbol(0);
            _1 = _01.getSymbol(1);
            ArrayList<FiniteAlphabet> alphas = new ArrayList<FiniteAlphabet>();
            alphas.add(DNATools.getDNA());
            alphas.add(_01);
            AbstractAlphabet quality = (AbstractAlphabet)AlphabetManager.getCrossProductAlphabet(alphas);
            CharacterTokenization tok = new CharacterTokenization(quality, true);
            SymbolList sl = DNATools.createDNA("agctrymkswhbvdn");
            ListTools.Doublet pair = new ListTools.Doublet();
            SymbolTokenization dnaTok = DNATools.getDNA().getTokenization("token");
            Iterator i = sl.iterator();
            while (i.hasNext()) {
                pair.setA((Symbol)i.next());
                String c = dnaTok.tokenizeSymbol((Symbol)pair.getA());
                pair.setB(_1);
                tok.bindSymbol(quality.getSymbol(pair), c.toUpperCase().charAt(0));
                pair.setB(_0);
                tok.bindSymbol(quality.getSymbol(pair), c.toLowerCase().charAt(0));
            }
            quality.putTokenization("token", tok);
            QUALITY = quality;
        }
        catch (Exception e) {
            throw new BioError("Could not initialize ABI quality alphabet", e);
        }
    }
}

