/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.program.das;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.biojava.bio.BioError;
import org.biojava.bio.BioException;
import org.biojava.bio.program.das.DAS;
import org.biojava.bio.program.das.DASSequenceDB;
import org.biojava.bio.program.das.FeatureFetcher;
import org.biojava.bio.program.das.Fetcher;
import org.biojava.bio.program.das.Segment;
import org.biojava.bio.program.das.TypesFetcher;
import org.biojava.bio.program.das.TypesListener;
import org.biojava.bio.seq.io.ParseException;
import org.biojava.bio.seq.io.SeqIOListener;
import org.biojava.bio.symbol.Location;

class FeatureRequestManager {
    private Set openTickets = new HashSet();
    private DASSequenceDB seqDB;

    FeatureRequestManager(DASSequenceDB seqDB) {
        this.seqDB = seqDB;
    }

    public Ticket requestFeatures(URL ds, String id, SeqIOListener l) {
        return this.requestFeatures(ds, id, l, null, null);
    }

    public Ticket requestFeatures(URL ds, String id, SeqIOListener l, Location loc) {
        return this.requestFeatures(ds, id, l, loc, null, null);
    }

    public Ticket requestFeatures(URL ds, String id, SeqIOListener l, String type, String category) {
        return this.requestFeatures(ds, id, l, null, type, category);
    }

    public Ticket requestFeatures(URL ds, String id, SeqIOListener l, Location loc, String type, String category) {
        if (id == null) {
            throw new NullPointerException("Null ID, you nutter!");
        }
        Segment seg = loc != null ? new Segment(id, loc.getMin(), loc.getMax()) : new Segment(id);
        FeatureTicket t = new FeatureTicket(ds, seg, type, category, l);
        this.openTickets.add(t);
        return t;
    }

    public Ticket requestTypes(URL ds, Segment segment, TypesListener l) {
        TypeTicket t = new TypeTicket(ds, segment, null, null, l);
        this.openTickets.add(t);
        return t;
    }

    private static boolean stringCompare(String a, String b) {
        if (a == null || b == null) {
            return a == b;
        }
        return a.equals(b);
    }

    private Fetcher makeFetcher(Ticket trigger) throws BioException {
        if (trigger instanceof FeatureTicket) {
            FeatureFetcher ffetcher = new FeatureFetcher(trigger.getDataSource(), trigger.getType(), trigger.getCategory());
            return ffetcher;
        }
        if (trigger instanceof TypeTicket) {
            TypesFetcher f = new TypesFetcher(trigger.getDataSource(), trigger.getType(), trigger.getCategory());
            return f;
        }
        throw new BioError("Unknown ticket class");
    }

    private synchronized void fetch(Ticket trigger) throws ParseException, BioException {
        Fetcher ffetcher;
        this.seqDB.ensureFeaturesCacheCapacity(this.openTickets.size() * 3);
        String triggerType = trigger.getType();
        String triggerCategory = trigger.getCategory();
        Class<?> triggerClass = trigger.getClass();
        Object triggerGroup = trigger.getFetchGroup();
        HashMap<URL, Fetcher> fetchers = new HashMap<URL, Fetcher>();
        Iterator<Object> i = this.openTickets.iterator();
        while (i.hasNext()) {
            Ticket t = (Ticket)i.next();
            if (!triggerClass.isInstance(t) || !FeatureRequestManager.stringCompare(triggerType, t.getType()) || !FeatureRequestManager.stringCompare(triggerCategory, t.getCategory()) || triggerGroup != t.getFetchGroup()) continue;
            URL dataSourceURL = t.getDataSource();
            ffetcher = (Fetcher)fetchers.get(dataSourceURL);
            if (ffetcher == null) {
                ffetcher = this.makeFetcher(t);
                fetchers.put(dataSourceURL, ffetcher);
            }
            ffetcher.addTicket(t);
        }
        if (fetchers.size() < 1) {
            System.err.println("*** Hmmm, don't actually seem to be fetching anything...");
            return;
        }
        if (DAS.getThreadFetches() && fetchers.size() > 1) {
            FetchMonitor monitor = new FetchMonitor();
            Iterator i2 = fetchers.values().iterator();
            while (i2.hasNext()) {
                monitor.addJob((Fetcher)i2.next());
            }
            List okay = monitor.doFetches();
            Iterator i3 = okay.iterator();
            while (i3.hasNext()) {
                ffetcher = (Fetcher)i3.next();
                this.openTickets.removeAll(ffetcher.getDoneTickets());
            }
        } else {
            i = fetchers.values().iterator();
            while (i.hasNext()) {
                Fetcher ffetcher2 = (Fetcher)i.next();
                ffetcher2.runFetch();
                this.openTickets.removeAll(ffetcher2.getDoneTickets());
            }
        }
    }

    public abstract class Ticket {
        private boolean _isFired = false;
        private Segment segment;
        private String type;
        private String category;
        private URL dataSource;
        private Object fetchGroup;

        public Ticket(URL dataSource, Segment segment, String type, String category) {
            this.dataSource = dataSource;
            this.type = type;
            this.category = category;
            this.segment = segment;
        }

        private URL getDataSource() {
            return this.dataSource;
        }

        private String getType() {
            return this.type;
        }

        private String getCategory() {
            return this.category;
        }

        public Segment getSegment() {
            return this.segment;
        }

        void setAsFetched() {
            this._isFired = true;
        }

        public void doFetch() throws ParseException, BioException {
            if (!this._isFired) {
                FeatureRequestManager.this.fetch(this);
            }
        }

        public boolean isFetched() {
            return this._isFired;
        }

        public void setFetchGroup(Object fg) {
            this.fetchGroup = fg;
        }

        public Object getFetchGroup() {
            return this.fetchGroup;
        }
    }

    class TypeTicket
    extends Ticket {
        private TypesListener outputListener;

        public TypeTicket(URL dataSource, Segment segment, String type, String category, TypesListener outputListener) {
            super(dataSource, segment, type, category);
            this.outputListener = outputListener;
        }

        public TypesListener getTypesListener() {
            return this.outputListener;
        }

        void setAsFetched() {
            super.setAsFetched();
            this.outputListener = null;
        }
    }

    class FeatureTicket
    extends Ticket {
        private SeqIOListener outputListener;

        public FeatureTicket(URL dataSource, Segment segment, String type, String category, SeqIOListener outputListener) {
            super(dataSource, segment, type, category);
            this.outputListener = outputListener;
        }

        public SeqIOListener getOutputListener() {
            return this.outputListener;
        }

        void setAsFetched() {
            super.setAsFetched();
            this.outputListener = null;
        }
    }

    private class FetchJob
    extends Thread {
        private Fetcher fetcher;
        private FetchMonitor monitor;

        FetchJob(Fetcher fetcher, FetchMonitor monitor) {
            this.fetcher = fetcher;
            this.monitor = monitor;
        }

        public Fetcher getFetcher() {
            return this.fetcher;
        }

        public void run() {
            try {
                this.fetcher.runFetch();
                this.monitor.jobSucceeded(this);
            }
            catch (Exception ex) {
                this.monitor.jobFailed(this, ex);
            }
        }
    }

    private class FetchMonitor {
        private Set pending = new HashSet();
        private List successes = new ArrayList();
        private FetchJob failedJob;
        private Exception failure;

        private FetchMonitor() {
        }

        public void addJob(Fetcher ff) {
            this.pending.add(new FetchJob(ff, this));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void jobSucceeded(FetchJob j) {
            Collection collection = this.successes;
            synchronized (collection) {
                this.successes.add(j.getFetcher());
            }
            collection = this.pending;
            synchronized (collection) {
                this.pending.remove(j);
                if (this.pending.size() == 0) {
                    this.pending.notifyAll();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void jobFailed(FetchJob j, Exception ex) {
            if (this.failedJob == null) {
                this.failedJob = j;
                this.failure = ex;
            }
            Set set = this.pending;
            synchronized (set) {
                this.pending.remove(j);
                if (this.pending.size() == 0) {
                    this.pending.notifyAll();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List doFetches() throws BioException {
            Set set = this.pending;
            synchronized (set) {
                Iterator i = this.pending.iterator();
                while (i.hasNext()) {
                    FetchJob job = (FetchJob)i.next();
                    job.start();
                }
                try {
                    this.pending.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (this.pending.size() != 0) {
                throw new BioError("Assertion failed: threads going screwy");
            }
            if (this.failedJob != null) {
                throw new BioException("Failure while fetching features from " + this.failedJob.getFetcher().getDataSourceURL(), this.failure);
            }
            return this.successes;
        }
    }
}

