/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.program.ssbind;

import java.util.HashMap;
import java.util.Map;
import org.biojava.bio.BioError;
import org.biojava.bio.BioException;
import org.biojava.bio.program.ssbind.AlphabetResolver;
import org.biojava.bio.program.ssbind.AnnotationFactory;
import org.biojava.bio.program.ssbind.ViewSequenceFactory;
import org.biojava.bio.search.SearchContentHandler;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.StrandedFeature;
import org.biojava.bio.seq.db.IllegalIDException;
import org.biojava.bio.seq.homol.SimilarityPairFeature;
import org.biojava.bio.seq.io.SymbolTokenization;
import org.biojava.bio.symbol.FiniteAlphabet;
import org.biojava.bio.symbol.RangeLocation;
import org.biojava.bio.symbol.SimpleAlignment;
import org.biojava.bio.symbol.SimpleSymbolList;
import org.biojava.utils.ChangeListener;
import org.biojava.utils.ChangeType;
import org.biojava.utils.ChangeVetoException;

public class SimilarityPairBuilder
extends ViewSequenceFactory
implements SearchContentHandler {
    public static final String SIMILARITY_PAIR_FEATURE_TYPE = "similarity";
    private String queryID;
    private Map resultData = new HashMap();
    private Map hitData = new HashMap();
    private Map subHitData = new HashMap();
    private AlphabetResolver alphaResolver;
    private SymbolTokenization tokenParser;
    private StringBuffer tokenBuffer;
    private boolean moreSearchesAvailable = false;

    public SimilarityPairBuilder() {
        this.queryViewCache = new HashMap();
        this.subjectViewCache = new HashMap();
        this.alphaResolver = new AlphabetResolver();
        this.tokenBuffer = new StringBuffer(1024);
    }

    public Sequence getAnnotatedQuerySeq(String queryID) throws IllegalIDException {
        if (!this.queryViewCache.containsKey(queryID)) {
            throw new IllegalIDException("Failed to retrieve annotated query sequence from cache using ID '" + queryID + "' (unknown ID");
        }
        return (Sequence)this.queryViewCache.get(queryID);
    }

    public Sequence getAnnotatedSubjectSeq(String subjectID) throws IllegalIDException {
        if (!this.subjectViewCache.containsKey(subjectID)) {
            throw new IllegalIDException("Failed to retrieve annotated subject sequence from cache using ID '" + subjectID + "' (unknown ID");
        }
        return (Sequence)this.subjectViewCache.get(subjectID);
    }

    public void setQueryID(String queryID) {
        this.queryID = queryID;
    }

    public boolean getMoreSearches() {
        return this.moreSearchesAvailable;
    }

    public void setMoreSearches(boolean value) {
        this.moreSearchesAvailable = value;
    }

    public void startSearch() {
        this.subjectViewCache.clear();
    }

    public void endSearch() {
    }

    public void startHeader() {
        this.resultData.clear();
    }

    public void endHeader() {
    }

    public void startHit() {
        this.hitData.clear();
        this.subHitData.clear();
    }

    public void endHit() {
    }

    public void startSubHit() {
    }

    public void endSubHit() {
        try {
            this.makeSimilarity();
        }
        catch (BioException be) {
            System.err.println("Failed to build Similarity:");
            be.printStackTrace();
        }
    }

    public void addSearchProperty(Object key, Object value) {
        this.resultData.put(key, value);
    }

    public void addHitProperty(Object key, Object value) {
        this.hitData.put(key, value);
    }

    public void addSubHitProperty(Object key, Object value) {
        this.subHitData.put(key, value);
    }

    private void makeSimilarity() throws BioException {
        int swap;
        this.subHitData.putAll(this.resultData);
        this.subHitData.putAll(this.hitData);
        if (this.tokenParser == null) {
            String identifier;
            if (this.subHitData.containsKey("hitSequenceType")) {
                identifier = (String)this.subHitData.get("hitSequenceType");
            } else if (this.subHitData.containsKey("program")) {
                identifier = (String)this.subHitData.get("program");
            } else {
                throw new BioException("Failed to determine sequence type");
            }
            FiniteAlphabet alpha = AlphabetResolver.resolveAlphabet(identifier);
            this.tokenParser = alpha.getTokenization("token");
        }
        StrandedFeature.Strand qStrand = StrandedFeature.POSITIVE;
        StrandedFeature.Strand sStrand = StrandedFeature.POSITIVE;
        if (this.subHitData.containsKey("queryStrand") && this.subHitData.get("queryStrand").equals("minus")) {
            qStrand = StrandedFeature.NEGATIVE;
        }
        if (this.subHitData.containsKey("subjectStrand") && this.subHitData.get("subjectStrand").equals("minus")) {
            sStrand = StrandedFeature.NEGATIVE;
        }
        if (this.subHitData.containsKey("queryFrame") && ((String)this.subHitData.get("queryFrame")).startsWith("minus")) {
            qStrand = StrandedFeature.NEGATIVE;
        }
        if (this.subHitData.containsKey("subjectFrame") && ((String)this.subHitData.get("subjectFrame")).startsWith("minus")) {
            sStrand = StrandedFeature.NEGATIVE;
        }
        int qStart = Integer.parseInt((String)this.subHitData.get("querySequenceStart"));
        int qEnd = Integer.parseInt((String)this.subHitData.get("querySequenceEnd"));
        int sStart = Integer.parseInt((String)this.subHitData.get("subjectSequenceStart"));
        int sEnd = Integer.parseInt((String)this.subHitData.get("subjectSequenceEnd"));
        if (qStrand == StrandedFeature.NEGATIVE) {
            swap = qStart;
            qStart = qEnd;
            qEnd = swap;
        }
        if (sStrand == StrandedFeature.NEGATIVE) {
            swap = sStart;
            sStart = sEnd;
            sEnd = swap;
        }
        String subjectID = (String)this.hitData.get("subjectId");
        Sequence queryView = this.makeQueryViewSequence(this.queryID);
        Sequence subjectView = this.makeSubjectViewSequence(subjectID);
        HashMap<String, SimpleSymbolList> labelMap = new HashMap<String, SimpleSymbolList>();
        try {
            String source = "unknown";
            if (this.subHitData.containsKey("program")) {
                source = (String)this.subHitData.get("program");
            }
            this.tokenBuffer.setLength(0);
            this.tokenBuffer.append((String)this.subHitData.get("querySequence"));
            labelMap.put("query", new SimpleSymbolList(this.tokenParser, this.tokenBuffer.substring(0)));
            this.tokenBuffer.setLength(0);
            this.tokenBuffer.append((String)this.subHitData.get("subjectSequence"));
            labelMap.put("subject", new SimpleSymbolList(this.tokenParser, this.tokenBuffer.substring(0)));
            double score = 0.0;
            if (this.subHitData.containsKey("score")) {
                score = Double.parseDouble((String)this.subHitData.get("score"));
            }
            SimilarityPairFeature.Template qt = new SimilarityPairFeature.Template();
            qt.type = SIMILARITY_PAIR_FEATURE_TYPE;
            qt.source = source;
            qt.location = new RangeLocation(qStart, qEnd);
            qt.strand = qStrand;
            qt.score = score;
            qt.annotation = AnnotationFactory.makeAnnotation(this.subHitData);
            SimilarityPairFeature.Template st = new SimilarityPairFeature.Template();
            st.type = SIMILARITY_PAIR_FEATURE_TYPE;
            st.source = source;
            st.location = new RangeLocation(sStart, sEnd);
            st.strand = sStrand;
            st.score = score;
            st.annotation = AnnotationFactory.makeAnnotation(this.subHitData);
            SimpleAlignment a = new SimpleAlignment(labelMap);
            qt.alignment = a;
            st.alignment = a;
            SimilarityPairFeature qf = (SimilarityPairFeature)queryView.createFeature(qt);
            SimilarityPairFeature sf = (SimilarityPairFeature)queryView.createFeature(qt);
            sf.setSibling(qf);
            qf.setSibling(sf);
            qf.addChangeListener(ChangeListener.ALWAYS_VETO, ChangeType.UNKNOWN);
            sf.addChangeListener(ChangeListener.ALWAYS_VETO, ChangeType.UNKNOWN);
        }
        catch (ChangeVetoException cve) {
            throw new BioError("Assertion failure creating SimilarityPairFeature. Template modification vetoed", cve);
        }
    }
}

