/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.db;

import com.kizna.html.HTMLNode;
import com.kizna.html.HTMLParser;
import com.kizna.html.HTMLRemarkNode;
import com.kizna.html.HTMLStringNode;
import java.util.Enumeration;
import java.util.StringTokenizer;
import org.biojava.bio.seq.db.FetchURL;

public class LocusLinkParser {
    private String nucleotideIDs = "";
    private String proteinIDs = "";
    private String omimIDs = "";
    private String unigeneIDs = "";
    private boolean formatChange = false;
    private String formatChangeHappened = "The file format has changed or exception has been thrown.";
    private String[] formatChangeHapp = new String[1];

    public LocusLinkParser(String locusLinkID) {
        this.parse(locusLinkID);
    }

    public String getProteinIDs() {
        if (this.formatChange) {
            return this.formatChangeHappened;
        }
        return this.proteinIDs;
    }

    public String getNucleotideIDs() {
        if (this.formatChange) {
            return this.formatChangeHappened;
        }
        return this.nucleotideIDs;
    }

    public String getOmimIDs() {
        if (this.formatChange) {
            return this.formatChangeHappened;
        }
        return this.omimIDs;
    }

    public String getUniGeneIDs() {
        if (this.formatChange) {
            return this.formatChangeHappened;
        }
        return this.unigeneIDs;
    }

    public String[] getProteinIDs_array() {
        StringTokenizer st = new StringTokenizer(this.proteinIDs, "\t");
        int numTokens = st.countTokens();
        if (numTokens == 0) {
            this.formatChangeHapp[0] = "The file format has changed or exception has been thrown.";
            return this.formatChangeHapp;
        }
        String[] proteinIDs_array = new String[numTokens];
        for (int i = 0; i < numTokens; ++i) {
            proteinIDs_array[i] = st.nextToken();
        }
        return proteinIDs_array;
    }

    public String[] getNucleotideIDs_array() {
        StringTokenizer st = new StringTokenizer(this.nucleotideIDs, "\t");
        int numTokens = st.countTokens();
        if (numTokens == 0) {
            this.formatChangeHapp[0] = "The file format has changed or exception has been thrown.";
            return this.formatChangeHapp;
        }
        String[] nucleotideIDs_array = new String[numTokens];
        for (int i = 0; i < numTokens; ++i) {
            nucleotideIDs_array[i] = st.nextToken();
        }
        return nucleotideIDs_array;
    }

    public String[] getOmimIDs_array() {
        StringTokenizer st = new StringTokenizer(this.omimIDs, "\t");
        int numTokens = st.countTokens();
        if (numTokens == 0) {
            this.formatChangeHapp[0] = "The file format has changed or exception has been thrown.";
            return this.formatChangeHapp;
        }
        String[] omimIDs_array = new String[numTokens];
        for (int i = 0; i < numTokens; ++i) {
            omimIDs_array[i] = st.nextToken();
        }
        return omimIDs_array;
    }

    private void parse(String locusLinkID) {
        String next;
        String tokenDeli;
        int i;
        FetchURL llURL = new FetchURL("LocusLink", "");
        String baseurl = llURL.getbaseURL();
        if (!baseurl.equalsIgnoreCase("")) {
            baseurl = llURL.getbaseURL();
        }
        String url = baseurl + "l=" + locusLinkID;
        System.out.println(url);
        HTMLParser parser = null;
        parser = new HTMLParser(url);
        String allStringNodes = "";
        String allRemarkNodes = "";
        Enumeration e = parser.elements();
        while (e.hasMoreElements()) {
            HTMLNode node = (HTMLNode)e.nextElement();
            if (node instanceof HTMLStringNode) {
                HTMLStringNode stringNode = (HTMLStringNode)node;
                allStringNodes = allStringNodes + stringNode.getText().trim() + "\t";
            }
            if (!(node instanceof HTMLRemarkNode)) continue;
            HTMLRemarkNode remarkNode = (HTMLRemarkNode)node;
            allRemarkNodes = allRemarkNodes + remarkNode.getText().trim() + "\t";
        }
        StringTokenizer st = new StringTokenizer(allStringNodes, "\t");
        StringTokenizer refSeq = new StringTokenizer(allStringNodes, "\t");
        StringTokenizer addLinks = new StringTokenizer(allStringNodes, "\t");
        StringTokenizer formatCheck = new StringTokenizer(allRemarkNodes, "\t");
        int numTokens = st.countTokens();
        int numRemarkNodes = formatCheck.countTokens();
        int flag = 0;
        for (i = 0; i < numRemarkNodes; ++i) {
            if (!formatCheck.nextToken().trim().equalsIgnoreCase("RefSeq Block")) continue;
            ++flag;
            tokenDeli = formatCheck.nextToken();
            while (!tokenDeli.trim().equalsIgnoreCase("GenBank Block") && !(tokenDeli = formatCheck.nextToken()).trim().equalsIgnoreCase("To Top")) {
            }
            if (tokenDeli.trim().equalsIgnoreCase("GenBank Block")) {
                ++flag;
            }
            String tokenDeli_2 = formatCheck.nextToken();
            while (!tokenDeli_2.trim().equalsIgnoreCase("Additional Links Block") && !(tokenDeli_2 = formatCheck.nextToken()).trim().equalsIgnoreCase("To Top")) {
            }
            if (!tokenDeli_2.trim().equalsIgnoreCase("Additional Links Block")) break;
            ++flag;
            break;
        }
        this.formatChange = flag != 3;
        for (i = 0; i < numTokens; ++i) {
            if (!st.nextToken().trim().equalsIgnoreCase("GenBank Sequences")) continue;
            for (int j = 0; j < 6; ++j) {
                st.nextToken();
            }
            tokenDeli = st.nextToken();
            while (!tokenDeli.trim().equalsIgnoreCase("Additional Links") && !tokenDeli.trim().equalsIgnoreCase("To Top")) {
                if (!tokenDeli.trim().equalsIgnoreCase("&nbsp;")) {
                    this.nucleotideIDs = this.nucleotideIDs + "Genbank: " + tokenDeli + "\t";
                }
                st.nextToken();
                next = st.nextToken();
                if (!next.trim().equalsIgnoreCase("&nbsp;")) {
                    this.proteinIDs = this.proteinIDs + "Genpept: " + next + "\t";
                }
                st.nextToken();
                st.nextToken();
                tokenDeli = st.nextToken();
            }
            break;
        }
        for (i = 0; i < numTokens; ++i) {
            if (!refSeq.nextToken().trim().equalsIgnoreCase("NCBI Reference Sequences&nbsp;(RefSeq)")) continue;
            tokenDeli = refSeq.nextToken();
            while (!(tokenDeli.trim().equalsIgnoreCase("GenBank Sequences") || tokenDeli.trim().equalsIgnoreCase("Additional Links") || tokenDeli.trim().equalsIgnoreCase("To Top"))) {
                next = refSeq.nextToken();
                if (next.trim().equalsIgnoreCase("mRNA:")) {
                    this.nucleotideIDs = this.nucleotideIDs + "RefSeq: " + refSeq.nextToken() + "\t";
                }
                if (next.trim().equalsIgnoreCase("Protein:")) {
                    this.proteinIDs = this.proteinIDs + "RefSeq: " + refSeq.nextToken() + "\t";
                }
                if (next.trim().equalsIgnoreCase("GenBank Source:")) {
                    this.nucleotideIDs = this.nucleotideIDs + "Genbank: " + refSeq.nextToken() + "\t";
                }
                if (next.trim().equalsIgnoreCase("Model mRNA:")) {
                    this.nucleotideIDs = this.nucleotideIDs + "RefSeq: " + refSeq.nextToken() + "\t";
                }
                if (next.trim().equalsIgnoreCase("Model Protein:")) {
                    this.proteinIDs = this.proteinIDs + "RefSeq: " + refSeq.nextToken() + "\t";
                }
                tokenDeli = next;
            }
            break;
        }
        for (i = 0; i < numTokens; ++i) {
            if (!addLinks.nextToken().trim().equalsIgnoreCase("Additional Links")) continue;
            tokenDeli = addLinks.nextToken();
            while (!tokenDeli.trim().equalsIgnoreCase("To Top")) {
                next = addLinks.nextToken();
                if (next.trim().equalsIgnoreCase("UniGene:")) {
                    this.unigeneIDs = this.unigeneIDs + addLinks.nextToken() + "\t";
                }
                if (next.trim().equalsIgnoreCase("Omim:")) {
                    this.omimIDs = this.omimIDs + addLinks.nextToken() + "\t";
                }
                tokenDeli = next;
            }
            break;
        }
    }
}

