/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.structure;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.biojava.bio.structure.Atom;
import org.biojava.bio.structure.Group;
import org.biojava.bio.structure.GroupIterator;
import org.biojava.bio.structure.Structure;
import org.biojava.bio.structure.StructureException;

public class AtomIterator
implements Iterator {
    Structure structure;
    Group group;
    int current_atom_pos;
    GroupIterator groupiter;

    public AtomIterator(Structure struct) {
        this.structure = struct;
        this.current_atom_pos = -1;
        this.groupiter = new GroupIterator(this.structure);
        this.group = this.groupiter.hasNext() ? (Group)this.groupiter.next() : null;
    }

    public AtomIterator(Group g) {
        this.structure = null;
        this.group = g;
        this.current_atom_pos = -1;
        this.groupiter = null;
    }

    public boolean hasNext() {
        if (this.current_atom_pos < this.group.size() - 1) {
            return true;
        }
        if (this.groupiter != null) {
            GroupIterator tmp = (GroupIterator)this.groupiter.clone();
            while (tmp.hasNext()) {
                Group tmpg = (Group)tmp.next();
                if (tmpg.size() <= 0) continue;
                return true;
            }
        } else {
            return false;
        }
        return false;
    }

    public Object next() throws NoSuchElementException {
        Atom a;
        ++this.current_atom_pos;
        if (this.current_atom_pos >= this.group.size()) {
            if (this.groupiter == null) {
                throw new NoSuchElementException("no more atoms found in group!");
            }
            if (this.groupiter.hasNext()) {
                this.group = (Group)this.groupiter.next();
                this.current_atom_pos = 0;
            } else {
                throw new NoSuchElementException("no more atoms found in structure!");
            }
        }
        try {
            a = this.group.getAtom(this.current_atom_pos);
        }
        catch (StructureException e) {
            e.printStackTrace();
            throw new NoSuchElementException("error wile trying to retrieve atom");
        }
        return a;
    }

    public void remove() {
    }
}

