/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.structure.io;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import org.biojava.bio.seq.ProteinTools;
import org.biojava.bio.seq.io.SymbolTokenization;
import org.biojava.bio.structure.AminoAcid;
import org.biojava.bio.structure.AtomImpl;
import org.biojava.bio.structure.Chain;
import org.biojava.bio.structure.ChainImpl;
import org.biojava.bio.structure.Group;
import org.biojava.bio.structure.Hetatom;
import org.biojava.bio.structure.Nucleotide;
import org.biojava.bio.structure.Structure;
import org.biojava.bio.structure.StructureImpl;
import org.biojava.bio.structure.io.PDBParseException;
import org.biojava.bio.structure.io.StructureIOFile;
import org.biojava.bio.symbol.FiniteAlphabet;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.Symbol;

public class PDBFileReader
implements StructureIOFile {
    String pdb_code;
    String path;
    ArrayList extensions = new ArrayList();
    StructureImpl structure = null;
    ArrayList current_model = new ArrayList();
    ChainImpl current_chain = null;
    Group current_group = null;
    SymbolTokenization threeLetter;
    SymbolTokenization oneLetter;
    String[] nucleotides;
    HashMap header = this.init_header();
    ArrayList connects = new ArrayList();

    public PDBFileReader() {
        FiniteAlphabet alpha_prot = ProteinTools.getAlphabet();
        try {
            this.threeLetter = alpha_prot.getTokenization("name");
            this.oneLetter = alpha_prot.getTokenization("token");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.nucleotides = new String[]{"C", "G", "A", "T", "U", "I", "+C", "+G", "+A", "+T", "+U", "+I"};
    }

    public void setId(String id) {
        this.pdb_code = id;
    }

    public String getId() {
        return this.pdb_code;
    }

    public void setPath(String p) {
        this.path = p;
    }

    public String getPath() {
        return this.path;
    }

    public void addExtension(String s) {
        System.out.println("add Extension " + s);
        this.extensions.add(s);
    }

    private HashMap init_header() {
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("idCode", "");
        header.put("classification", "");
        header.put("depDate", "0000-00-00");
        header.put("title", "");
        header.put("technique", "");
        header.put("resolution", "");
        return header;
    }

    protected String getTimeStamp() {
        Calendar cal = Calendar.getInstance();
        int hour24 = cal.get(11);
        int min = cal.get(12);
        int sec = cal.get(13);
        String s = "time: " + hour24 + " " + min + " " + sec;
        return s;
    }

    private FileInputStream getInputStream() throws IOException {
        System.out.println("checking file");
        String[] str = new String[]{".gz", ".zip", ".Z"};
        ArrayList<String> compressions = new ArrayList<String>(Arrays.asList(str));
        FileInputStream inputStream = null;
        String pdbFile = null;
        File f = null;
        String fpath = this.path + "/" + this.pdb_code;
        for (int i = 0; i < this.extensions.size(); ++i) {
            String ex = (String)this.extensions.get(i);
            System.out.println("testing: " + fpath + ex);
            f = new File(fpath + ex);
            if (f.exists()) {
                System.out.println("found!");
                pdbFile = fpath + ex;
                inputStream = new FileInputStream(pdbFile);
                break;
            }
            if (pdbFile != null) break;
        }
        if (pdbFile == null) {
            String message = "no structure with PDB code " + this.pdb_code + " found!";
            throw new IOException(message);
        }
        return inputStream;
    }

    private Character convert_3code_1code(String code3) throws IllegalSymbolException {
        Symbol sym = this.threeLetter.parseToken(code3);
        String code1 = this.oneLetter.tokenizeSymbol(sym);
        return new Character(code1.charAt(0));
    }

    private Group getNewGroup(String recordName, Character aminoCode1) {
        Hetatom group;
        if (recordName.equals("ATOM")) {
            if (aminoCode1 != null) {
                AminoAcid aa = new AminoAcid();
                aa.setAminoType(aminoCode1);
                group = aa;
            } else {
                Nucleotide nu = new Nucleotide();
                group = nu;
            }
        } else {
            group = new Hetatom();
        }
        return group;
    }

    private boolean isNucleotide(String groupCode3) {
        for (int i = 0; i < this.nucleotides.length; ++i) {
            String n = this.nucleotides[i];
            if (!groupCode3.trim().equals(n)) continue;
            return true;
        }
        return false;
    }

    private void pdb_HEADER_Handler(String line) {
        System.out.println(line);
        String classification = line.substring(10, 50).trim();
        String deposition_date = line.substring(50, 59).trim();
        String idCode = line.substring(62, 66).trim();
        this.header.put("idCode", idCode);
        this.structure.setPDBCode(idCode);
        this.header.put("classification", classification);
        this.header.put("depDate", deposition_date);
        this.structure.setPDBCode(idCode);
        this.setId(idCode);
    }

    private void pdb_TITLE_Handler(String line) {
        String title = line.substring(10, 70).trim();
        String t = (String)this.header.get("title");
        t = t + title + " ";
        this.header.put("title", t);
    }

    private void pdb_REMARK_2_Handler(String line) {
        int i = line.indexOf("ANGSTROM");
        if (i != -1) {
            String resolution = line.substring(22, 27).trim();
            float res = 99.0f;
            try {
                res = Float.parseFloat(resolution);
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
                return;
            }
            this.header.put("resolution", new Float(res));
        }
    }

    private void pdb_REMARK_Handler(String line) {
        String l = line.substring(0, 10).trim();
        if (l.equals("REMARK   2")) {
            this.pdb_REMARK_2_Handler(line);
        }
    }

    private void pdb_EXPDTA_Handler(String line) {
        String technique = line.substring(10, 70).trim();
        String t = (String)this.header.get("technique");
        t = t + technique + " ";
        this.header.put("technique", t);
        int nmr = technique.indexOf("NMR");
        if (nmr != -1) {
            this.structure.setNmr(true);
        }
    }

    private void pdb_ATOM_Handler(String line) throws PDBParseException {
        String recordName = line.substring(0, 6).trim();
        AtomImpl atom = new AtomImpl();
        int pdbnumber = Integer.parseInt(line.substring(6, 11).trim());
        atom.setPDBserial(pdbnumber);
        String fullname = line.substring(12, 16);
        String altLoc = line.substring(16, 17);
        atom.setFullName(fullname);
        atom.setName(fullname.trim());
        double x = Double.parseDouble(line.substring(30, 38).trim());
        double y = Double.parseDouble(line.substring(38, 46).trim());
        double z = Double.parseDouble(line.substring(46, 54).trim());
        double[] coords = new double[]{x, y, z};
        atom.setCoords(coords);
        double occu = Double.parseDouble(line.substring(54, 60).trim());
        double tempf = Double.parseDouble(line.substring(60, 66).trim());
        atom.setOccupancy(occu);
        atom.setTempFactor(tempf);
        String chain_id = line.substring(21, 22);
        String residueNumber = line.substring(22, 27).trim();
        String groupCode3 = line.substring(17, 20);
        Character aminoCode1 = null;
        if (recordName.equals("ATOM")) {
            try {
                aminoCode1 = this.convert_3code_1code(groupCode3);
            }
            catch (IllegalSymbolException e) {
                if (this.isNucleotide(groupCode3)) {
                    aminoCode1 = null;
                }
                System.out.println("unknown amino acid" + groupCode3);
                aminoCode1 = new Character('x');
            }
        }
        if (this.current_chain == null) {
            this.current_chain = new ChainImpl();
            this.current_chain.setName(chain_id);
        }
        if (this.current_group == null) {
            this.current_group = this.getNewGroup(recordName, aminoCode1);
            this.current_group.setPDBCode(residueNumber);
            this.current_group.setPDBName(groupCode3);
        }
        if (!chain_id.equals(this.current_chain.getName())) {
            this.current_chain.addGroup(this.current_group);
            Chain testchain = this.isKnownChain(this.current_chain.getName());
            if (testchain == null) {
                this.current_model.add(this.current_chain);
            }
            if ((testchain = this.isKnownChain(chain_id)) != null) {
                this.current_chain = (ChainImpl)testchain;
            } else {
                this.current_chain = new ChainImpl();
                this.current_chain.setName(chain_id);
            }
            this.current_group = this.getNewGroup(recordName, aminoCode1);
            this.current_group.setPDBCode(residueNumber);
            this.current_group.setPDBName(groupCode3);
        }
        if (!residueNumber.equals(this.current_group.getPDBCode())) {
            this.current_chain.addGroup(this.current_group);
            this.current_group = this.getNewGroup(recordName, aminoCode1);
            this.current_group.setPDBCode(residueNumber);
            this.current_group.setPDBName(groupCode3);
        }
        this.current_group.addAtom(atom);
    }

    private Integer conect_helper(String line, int start, int end) {
        String sbond = line.substring(start, end).trim();
        int bond = -1;
        Integer b = null;
        if (!sbond.equals("")) {
            bond = Integer.parseInt(sbond);
            b = new Integer(bond);
        }
        return b;
    }

    private void pdb_CONECT_Handler(String line) {
        int atomserial = Integer.parseInt(line.substring(6, 11).trim());
        Integer bond1 = this.conect_helper(line, 11, 16);
        Integer bond2 = this.conect_helper(line, 16, 21);
        Integer bond3 = this.conect_helper(line, 21, 26);
        Integer bond4 = this.conect_helper(line, 26, 31);
        Integer hyd1 = this.conect_helper(line, 31, 36);
        Integer hyd2 = this.conect_helper(line, 36, 41);
        Integer salt1 = this.conect_helper(line, 41, 46);
        Integer hyd3 = this.conect_helper(line, 46, 51);
        Integer hyd4 = this.conect_helper(line, 51, 56);
        Integer salt2 = this.conect_helper(line, 56, 61);
        HashMap<String, Integer> cons = new HashMap<String, Integer>();
        cons.put("atomserial", new Integer(atomserial));
        if (bond1 != null) {
            cons.put("bond1", bond1);
        }
        if (bond2 != null) {
            cons.put("bond2", bond2);
        }
        if (bond3 != null) {
            cons.put("bond3", bond3);
        }
        if (bond4 != null) {
            cons.put("bond4", bond4);
        }
        if (hyd1 != null) {
            cons.put("hydrogen1", hyd1);
        }
        if (hyd2 != null) {
            cons.put("hydrogen2", hyd2);
        }
        if (salt1 != null) {
            cons.put("salt1", salt1);
        }
        if (hyd3 != null) {
            cons.put("hydrogen3", hyd3);
        }
        if (hyd4 != null) {
            cons.put("hydrogen4", hyd4);
        }
        if (salt1 != null) {
            cons.put("salt2", salt2);
        }
        this.connects.add(cons);
    }

    private void pdb_MODEL_Handler(String line) {
        if (this.current_chain != null) {
            Chain ch;
            if (this.current_group != null) {
                this.current_chain.addGroup(this.current_group);
            }
            if ((ch = this.isKnownChain(this.current_chain.getName())) == null) {
                this.current_model.add(this.current_chain);
            }
            this.structure.addModel(this.current_model);
            this.current_model = new ArrayList();
            this.current_chain = null;
            this.current_group = null;
        }
    }

    private Chain isKnownChain(String chainID) {
        Chain testchain = null;
        Chain retchain = null;
        for (int i = 0; i < this.current_model.size(); ++i) {
            testchain = (Chain)this.current_model.get(i);
            if (!chainID.equals(testchain.getName())) continue;
            retchain = testchain;
            break;
        }
        return retchain;
    }

    private BufferedReader getBufferedReader(InputStream inStream) throws IOException {
        if (inStream == null) {
            throw new IOException("input stream is null!");
        }
        BufferedReader buf = new BufferedReader(new InputStreamReader(inStream));
        return buf;
    }

    public Structure parsePDBFile(InputStream inStream) throws IOException, PDBParseException {
        BufferedReader buf;
        System.out.println("preparing buffer");
        try {
            buf = this.getBufferedReader(inStream);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new IOException("error initializing BufferedReader");
        }
        System.out.println("done");
        return this.parsePDBFile(buf);
    }

    public Structure parsePDBFile(BufferedReader buf) throws IOException, PDBParseException {
        System.out.println("parsePDBFile");
        this.structure = new StructureImpl();
        this.current_model = new ArrayList();
        this.current_chain = null;
        this.current_group = null;
        this.header = this.init_header();
        this.connects = new ArrayList();
        try {
            String line = buf.readLine();
            String recordName = "";
            while (line != null) {
                recordName = line.substring(0, 6).trim();
                if (recordName.equals("ATOM")) {
                    this.pdb_ATOM_Handler(line);
                } else if (recordName.equals("HETATM")) {
                    this.pdb_ATOM_Handler(line);
                } else if (recordName.equals("MODEL")) {
                    this.pdb_MODEL_Handler(line);
                } else if (recordName.equals("HEADER")) {
                    this.pdb_HEADER_Handler(line);
                } else if (recordName.equals("TITLE")) {
                    this.pdb_TITLE_Handler(line);
                } else if (recordName.equals("EXPDTA")) {
                    this.pdb_EXPDTA_Handler(line);
                } else if (recordName.equals("REMARK")) {
                    this.pdb_REMARK_Handler(line);
                } else if (recordName.equals("CONECT")) {
                    this.pdb_CONECT_Handler(line);
                }
                line = buf.readLine();
            }
            System.out.println("final checks...");
            this.current_chain.addGroup(this.current_group);
            if (this.isKnownChain(this.current_chain.getName()) == null) {
                this.current_model.add(this.current_chain);
            }
            this.structure.addModel(this.current_model);
            this.structure.setHeader(this.header);
            this.structure.setConnections(this.connects);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IOException("Error parsing PDB file");
        }
        return this.structure;
    }

    public Structure getStructure() throws IOException {
        FileInputStream inStream = this.getInputStream();
        try {
            System.out.println("Starting to parse PDB file " + this.getTimeStamp());
            this.parsePDBFile(inStream);
            System.out.println("Done parsing PDB file " + this.getTimeStamp());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return this.structure;
    }

    public Structure getStructure(String filename) throws IOException {
        FileInputStream inStream = new FileInputStream(filename);
        try {
            this.parsePDBFile(inStream);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return this.structure;
    }
}

