/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.localstore;

import java.io.File;
import org.eclipse.core.internal.resources.ResourceException;
import org.eclipse.core.internal.resources.ResourceStatus;
import org.eclipse.core.internal.utils.Convert;
import org.eclipse.core.internal.utils.Policy;
import org.eclipse.core.resources.ResourceAttributes;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;

public abstract class CoreFileSystemLibrary {
    private static final boolean caseSensitive = new File("a").compareTo(new File("A")) != 0;
    private static boolean hasNatives = false;
    private static boolean isUnicode = false;
    private static final String LIBRARY_NAME = "core_3_1_0";
    private static boolean loggedFailedGetAttributes = false;
    private static final long STAT_FOLDER = 0x2000000000000000L;
    private static final long STAT_READ_ONLY = 0x1000000000000000L;
    private static final long STAT_RESERVED = Long.MIN_VALUE;
    private static final long STAT_VALID = 0x4000000000000000L;
    private static final long STAT_LASTMODIFIED = 0xFFFFFFFFFFFFFFFL;

    static {
        try {
            System.loadLibrary(LIBRARY_NAME);
            hasNatives = true;
            isUnicode = CoreFileSystemLibrary.internalIsUnicode();
        }
        catch (UnsatisfiedLinkError e) {
            CoreFileSystemLibrary.logMissingNativeLibrary(e);
        }
    }

    public static boolean copyAttributes(String source, String destination, boolean copyLastModified) {
        if (hasNatives) {
            return isUnicode ? CoreFileSystemLibrary.internalCopyAttributesW(source.toCharArray(), destination.toCharArray(), copyLastModified) : CoreFileSystemLibrary.internalCopyAttributes(Convert.toPlatformBytes(source), Convert.toPlatformBytes(destination), copyLastModified);
        }
        return false;
    }

    public static long getLastModified(long stat) {
        return stat & 0xFFFFFFFFFFFFFFFL;
    }

    public static long getLastModified(String fileName) {
        if (hasNatives) {
            return CoreFileSystemLibrary.getLastModified(CoreFileSystemLibrary.getStat(fileName));
        }
        return new File(fileName).lastModified();
    }

    public static ResourceAttributes getResourceAttributes(String fileName) {
        block4: {
            try {
                ResourceAttributes attributes = new ResourceAttributes();
                if (!hasNatives) {
                    attributes.setReadOnly(CoreFileSystemLibrary.isReadOnly(fileName));
                    return attributes;
                }
                if (isUnicode ? CoreFileSystemLibrary.internalGetResourceAttributesW(fileName.toCharArray(), attributes) : CoreFileSystemLibrary.internalGetResourceAttributes(Convert.toPlatformBytes(fileName), attributes)) {
                    return attributes;
                }
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                if (loggedFailedGetAttributes) break block4;
                loggedFailedGetAttributes = true;
                String message = Policy.bind("resources.getResourceAttributesFailed", fileName);
                ResourceStatus status = new ResourceStatus(1, (IPath)new Path(fileName), message);
                ResourcesPlugin.getPlugin().getLog().log((IStatus)status);
            }
        }
        return null;
    }

    public static long getStat(String fileName) {
        if (hasNatives) {
            return isUnicode ? CoreFileSystemLibrary.internalGetStatW(fileName.toCharArray()) : CoreFileSystemLibrary.internalGetStat(Convert.toPlatformBytes(fileName));
        }
        File target = new File(fileName);
        long result = target.lastModified();
        if (result == 0L) {
            return result;
        }
        result |= 0x4000000000000000L;
        if (target.isDirectory()) {
            result |= 0x2000000000000000L;
        }
        if (!new File(fileName).canWrite()) {
            result |= 0x1000000000000000L;
        }
        return result;
    }

    private static final native boolean internalCopyAttributes(byte[] var0, byte[] var1, boolean var2);

    private static final native boolean internalCopyAttributesW(char[] var0, char[] var1, boolean var2);

    private static final native boolean internalGetResourceAttributes(byte[] var0, ResourceAttributes var1);

    private static final native boolean internalGetResourceAttributesW(char[] var0, ResourceAttributes var1);

    private static final native long internalGetStat(byte[] var0);

    private static final native long internalGetStatW(char[] var0);

    private static final native boolean internalIsUnicode();

    private static final native boolean internalSetResourceAttributes(byte[] var0, ResourceAttributes var1);

    private static final native boolean internalSetResourceAttributesW(char[] var0, ResourceAttributes var1);

    public static boolean isCaseSensitive() {
        return caseSensitive;
    }

    public static boolean isFile(long stat) {
        return CoreFileSystemLibrary.isSet(stat, 0x4000000000000000L) && !CoreFileSystemLibrary.isSet(stat, 0x2000000000000000L);
    }

    public static boolean isFolder(long stat) {
        return CoreFileSystemLibrary.isSet(stat, 0x4000000000000000L) && CoreFileSystemLibrary.isSet(stat, 0x2000000000000000L);
    }

    public static boolean isReadOnly(String fileName) {
        return CoreFileSystemLibrary.isSet(CoreFileSystemLibrary.getStat(fileName), 0x1000000000000000L);
    }

    public static boolean isReadOnly(long stat) {
        return CoreFileSystemLibrary.isSet(stat, 0x1000000000000000L);
    }

    private static boolean isSet(long stat, long mask) {
        return (stat & mask) != 0L;
    }

    private static void logMissingNativeLibrary(UnsatisfiedLinkError e) {
        String libName = System.mapLibraryName(LIBRARY_NAME);
        String message = Policy.bind("localstore.couldNotLoadLibrary", libName);
        ResourceStatus status = new ResourceStatus(1, null, message, null);
        ResourcesPlugin.getPlugin().getLog().log((IStatus)status);
    }

    public static boolean setReadOnly(String fileName, boolean readonly) {
        ResourceAttributes attributes = CoreFileSystemLibrary.getResourceAttributes(fileName);
        if (attributes == null) {
            return false;
        }
        attributes.setReadOnly(readonly);
        try {
            CoreFileSystemLibrary.setResourceAttributes(fileName, attributes);
        }
        catch (CoreException coreException) {
            return false;
        }
        return true;
    }

    public static void setResourceAttributes(String fileName, ResourceAttributes attributes) throws CoreException {
        if (!hasNatives) {
            return;
        }
        if (isUnicode ? CoreFileSystemLibrary.internalSetResourceAttributesW(fileName.toCharArray(), attributes) : CoreFileSystemLibrary.internalSetResourceAttributes(Convert.toPlatformBytes(fileName), attributes)) {
            return;
        }
        String message = Policy.bind("resources.setResourceAttributesFailed", fileName);
        throw new ResourceException(272, (IPath)new Path(fileName), message, null);
    }

    public static boolean usingNatives() {
        return hasNatives;
    }
}

