/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources;

import java.util.Arrays;
import org.eclipse.core.runtime.Platform;

public abstract class OS {
    private static final String INSTALLED_PLATFORM;
    public static final char[] INVALID_RESOURCE_CHARACTERS;
    public static final String[] INVALID_RESOURCE_NAMES;

    static {
        char[] chars = null;
        Object[] names = null;
        INSTALLED_PLATFORM = Platform.getOS();
        if (INSTALLED_PLATFORM.equals("win32")) {
            chars = new char[]{'\\', '/', ':', '*', '?', '\"', '<', '>', '|'};
            names = new String[]{"aux", "clock$", "com1", "com2", "com3", "com4", "com5", "com6", "com7", "com8", "com9", "con", "lpt1", "lpt2", "lpt3", "lpt4", "lpt5", "lpt6", "lpt7", "lpt8", "lpt9", "nul", "prn"};
        } else {
            char[] cArray = new char[2];
            cArray[0] = 47;
            chars = cArray;
            names = new String[]{};
        }
        INVALID_RESOURCE_CHARACTERS = chars == null ? new char[]{} : chars;
        Arrays.sort(names);
        INVALID_RESOURCE_NAMES = names;
    }

    public static boolean isNameValid(String name) {
        if (name.equals(".") || name.equals("..")) {
            return false;
        }
        if (INSTALLED_PLATFORM.equals("win32")) {
            int dot = name.indexOf(46);
            String string = name = dot == -1 ? name : name.substring(0, dot);
        }
        return Arrays.binarySearch(INVALID_RESOURCE_NAMES, name.toLowerCase()) < 0;
    }
}

