/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.search;

import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.PluginVersionIdentifier;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.update.configuration.IConfiguredSite;
import org.eclipse.update.configuration.IInstallConfiguration;
import org.eclipse.update.configuration.ILocalSite;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.core.IFeatureReference;
import org.eclipse.update.core.IIncludedFeatureReference;
import org.eclipse.update.core.ISite;
import org.eclipse.update.core.ISiteFeatureReference;
import org.eclipse.update.core.IURLEntry;
import org.eclipse.update.core.SiteManager;
import org.eclipse.update.core.VersionedIdentifier;
import org.eclipse.update.internal.core.Policy;
import org.eclipse.update.internal.core.UpdateCore;
import org.eclipse.update.internal.operations.FeatureHierarchyElement;
import org.eclipse.update.internal.operations.UpdateUtils;
import org.eclipse.update.internal.search.BaseSearchCategory;
import org.eclipse.update.internal.search.QueryUpdateSiteAdapter;
import org.eclipse.update.operations.IInstallFeatureOperation;
import org.eclipse.update.operations.OperationsManager;
import org.eclipse.update.search.IQueryUpdateSiteAdapter;
import org.eclipse.update.search.IUpdateSearchFilter;
import org.eclipse.update.search.IUpdateSearchQuery;
import org.eclipse.update.search.IUpdateSearchResultCollector;

public class UpdatesSearchCategory
extends BaseSearchCategory {
    private static final String CATEGORY_ID = "org.eclipse.update.core.new-updates";
    private IFeature[] features;
    private ArrayList candidates;

    public UpdatesSearchCategory() {
        super(CATEGORY_ID);
    }

    private void collectValidHits(ArrayList hits, IUpdateSearchFilter filter, IUpdateSearchResultCollector collector) {
        hits.toArray();
        IFeature topHit = null;
        int i = 0;
        while (i < hits.size()) {
            Hit hit = (Hit)hits.get(i);
            IInstallFeatureOperation job = hit.getJob();
            if (job != null) {
                if (!UpdateUtils.hasLicense(job.getFeature())) {
                    UpdateCore.log(job.getFeature().getVersionedIdentifier() + ": " + Policy.bind("DefaultFeatureParser.NoLicenseText"), null);
                } else {
                    IStatus status = hit.getPatchedJob() == null ? OperationsManager.getValidator().validatePendingInstall(job.getOldFeature(), job.getFeature()) : OperationsManager.getValidator().validatePendingChanges(new IInstallFeatureOperation[]{hit.getPatchedJob(), job});
                    if (status == null || status.getCode() == 2) {
                        if (hit.isPatch()) {
                            IFeature patch = job.getFeature();
                            IFeature[] sameId = UpdateUtils.getInstalledFeatures(patch, false);
                            if (sameId.length == 0 && filter.accept(patch)) {
                                collector.accept(patch);
                            }
                        } else if (topHit == null && filter.accept(topHit = job.getFeature())) {
                            collector.accept(topHit);
                        }
                    }
                }
            }
            ++i;
        }
    }

    private void initialize() {
        this.candidates = new ArrayList();
        try {
            ILocalSite localSite = SiteManager.getLocalSite();
            IInstallConfiguration config = localSite.getCurrentConfiguration();
            IConfiguredSite[] isites = config.getConfiguredSites();
            int i = 0;
            while (i < isites.length) {
                this.contributeCandidates(isites[i]);
                ++i;
            }
        }
        catch (CoreException e) {
            UpdateCore.log(Policy.bind("UpdatesSearchCategory.errorSearchingForUpdates"), e);
        }
    }

    private void contributeCandidates(IConfiguredSite isite) throws CoreException {
        IFeatureReference[] refs = isite.getConfiguredFeatures();
        ArrayList<Candidate> candidatesPerSite = new ArrayList<Candidate>();
        int i = 0;
        while (i < refs.length) {
            block4: {
                IFeatureReference ref = refs[i];
                try {
                    if (UpdateUtils.isPatch(ref.getFeature(null))) {
                    }
                }
                catch (CoreException coreException) {}
                break block4;
                Candidate c = new Candidate(ref);
                candidatesPerSite.add(c);
            }
            ++i;
        }
        this.buildHierarchy(candidatesPerSite);
        this.candidates.addAll(candidatesPerSite);
    }

    private void buildHierarchy(ArrayList candidates) throws CoreException {
        Candidate[] array = candidates.toArray(new Candidate[candidates.size()]);
        int i = 0;
        while (i < array.length) {
            Candidate parent = array[i];
            IFeature feature = parent.getFeature(null);
            IIncludedFeatureReference[] included = feature.getIncludedFeatureReferences();
            int j = 0;
            while (j < included.length) {
                IIncludedFeatureReference fref = included[j];
                Candidate child = this.findCandidate(candidates, fref);
                if (child != null) {
                    parent.add(child);
                    child.setReference(fref);
                    candidates.remove(child);
                }
                ++j;
            }
            ++i;
        }
    }

    private Candidate findCandidate(ArrayList list, IFeatureReference ref) {
        int i = 0;
        while (i < list.size()) {
            Candidate c = (Candidate)list.get(i);
            if (c.ref.equals(ref)) {
                return c;
            }
            ++i;
        }
        return null;
    }

    public IUpdateSearchQuery[] getQueries() {
        this.initialize();
        ArrayList allCandidates = this.getAllCandidates();
        IUpdateSearchQuery[] queries = new IUpdateSearchQuery[allCandidates.size()];
        int i = 0;
        while (i < queries.length) {
            Candidate candidate = (Candidate)allCandidates.get(i);
            IFeature feature = candidate.getFeature(null);
            IURLEntry updateEntry = candidate.getUpdateEntry();
            queries[i] = feature == null ? null : new UpdateQuery(feature, updateEntry);
            ++i;
        }
        return queries;
    }

    public void setFeatures(IFeature[] features) {
        this.features = features;
    }

    public IFeature[] getFeatures() {
        return this.features;
    }

    private boolean isNewerVersion(VersionedIdentifier fvi, VersionedIdentifier cvi) {
        if (!fvi.getIdentifier().equals(cvi.getIdentifier())) {
            return false;
        }
        PluginVersionIdentifier fv = fvi.getVersion();
        PluginVersionIdentifier cv = cvi.getVersion();
        String mode = this.getUpdateVersionsMode();
        boolean greater = cv.isGreaterThan(fv);
        if (!greater) {
            return false;
        }
        if (mode.equals("equivalent")) {
            return cv.isEquivalentTo(fv);
        }
        if (mode.equals("compatible")) {
            return cv.isCompatibleWith(fv);
        }
        return false;
    }

    private boolean isPatch(IFeature candidate, ISiteFeatureReference ref) {
        if (!ref.isPatch()) {
            return false;
        }
        try {
            IFeature feature = ref.getFeature(null);
            if (UpdateUtils.isPatch(candidate, feature)) {
                return true;
            }
            try {
                IIncludedFeatureReference[] children = candidate.getIncludedFeatureReferences();
                int i = 0;
                while (i < children.length) {
                    IIncludedFeatureReference cref = children[i];
                    try {
                        IFeature child = cref.getFeature(null);
                        if (this.isPatch(child, ref)) {
                            return true;
                        }
                    }
                    catch (CoreException coreException) {}
                    ++i;
                }
            }
            catch (CoreException coreException) {}
            return false;
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    private String getUpdateVersionsMode() {
        Preferences store = UpdateCore.getPlugin().getPluginPreferences();
        return store.getString("org.eclipse.update.core.updateVersions");
    }

    private ArrayList getAllCandidates() {
        ArrayList selected = new ArrayList();
        int i = 0;
        while (i < this.candidates.size()) {
            Candidate c = (Candidate)this.candidates.get(i);
            if (this.isOnTheList(c)) {
                c.addToFlatList(selected, true);
            }
            ++i;
        }
        return selected;
    }

    private boolean isOnTheList(Candidate c) {
        VersionedIdentifier vid;
        if (this.features == null) {
            return true;
        }
        try {
            vid = c.getReference().getVersionedIdentifier();
        }
        catch (CoreException coreException) {
            return false;
        }
        int i = 0;
        while (i < this.features.length) {
            IFeature feature = this.features[i];
            VersionedIdentifier fvid = feature.getVersionedIdentifier();
            if (fvid.equals(vid)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    class Candidate {
        ArrayList children;
        Candidate parent;
        IFeatureReference ref;

        public Candidate(IFeatureReference ref) {
            this.ref = ref;
        }

        public Candidate(IFeatureReference ref, Candidate parent) {
            this(ref);
            this.parent = parent;
        }

        public void add(Candidate child) {
            if (this.children == null) {
                this.children = new ArrayList();
            }
            child.setParent(this);
            this.children.add(child);
        }

        void setParent(Candidate parent) {
            this.parent = parent;
        }

        public IFeatureReference getReference() {
            return this.ref;
        }

        void setReference(IFeatureReference ref) {
            this.ref = ref;
        }

        public IFeature getFeature(IProgressMonitor monitor) {
            try {
                return this.ref.getFeature(monitor);
            }
            catch (CoreException coreException) {
                return null;
            }
        }

        public Candidate getParent() {
            return this.parent;
        }

        public Candidate getRoot() {
            Candidate root = this;
            while (root.getParent() != null) {
                root = root.getParent();
            }
            return root;
        }

        public IURLEntry getUpdateEntry() {
            int location = 2;
            if (this.ref instanceof IIncludedFeatureReference) {
                location = ((IIncludedFeatureReference)this.ref).getSearchLocation();
            }
            if (this.parent == null || location == 4) {
                return this.getFeature(null).getUpdateSiteEntry();
            }
            return this.getRoot().getUpdateEntry();
        }

        public String toString() {
            return this.ref.toString();
        }

        public boolean equals(Object source) {
            if (source instanceof Candidate) {
                return this.ref.equals(((Candidate)source).getReference());
            }
            if (source instanceof IFeatureReference) {
                return this.ref.equals(source);
            }
            return false;
        }

        public void addToFlatList(ArrayList list, boolean updatableOnly) {
            if (!updatableOnly || this.isUpdatable()) {
                list.add(this);
            }
            if (this.children != null) {
                int i = 0;
                while (i < this.children.size()) {
                    Candidate child = (Candidate)this.children.get(i);
                    child.addToFlatList(list, updatableOnly);
                    ++i;
                }
            }
        }

        public boolean isUpdatable() {
            return this.parent == null;
        }
    }

    private static class Hit {
        IFeature candidate;
        IFeatureReference ref;
        IInstallFeatureOperation patchFor;
        boolean patch;
        IInstallFeatureOperation job;

        public Hit(IFeature candidate, IFeatureReference ref) {
            this.candidate = candidate;
            this.ref = ref;
        }

        public Hit(IFeature candidate, IFeatureReference ref, boolean patch) {
            this(candidate, ref);
            this.patch = patch;
        }

        public Hit(IFeature candidate, IFeatureReference ref, IInstallFeatureOperation patchFor) {
            this(candidate, ref, true);
            this.patchFor = patchFor;
        }

        public IInstallFeatureOperation getJob() {
            if (this.job == null) {
                try {
                    IFeature feature = this.ref.getFeature(null);
                    this.job = OperationsManager.getOperationFactory().createInstallOperation(null, feature, null, null, null);
                }
                catch (CoreException e) {
                    UpdateCore.log(e);
                }
            }
            return this.job;
        }

        public boolean isPatch() {
            return this.patch;
        }

        public IInstallFeatureOperation getPatchedJob() {
            return this.patchFor;
        }
    }

    class UpdateQuery
    implements IUpdateSearchQuery {
        IFeature candidate;
        IQueryUpdateSiteAdapter adapter;

        public UpdateQuery(IFeature candidate, IURLEntry updateEntry) {
            this.candidate = candidate;
            if (updateEntry != null && updateEntry.getURL() != null) {
                this.adapter = new QueryUpdateSiteAdapter(this.getLabelForEntry(updateEntry), updateEntry.getURL(), candidate.getVersionedIdentifier().getIdentifier());
            }
        }

        private String getLabelForEntry(IURLEntry entry) {
            String label = entry.getAnnotation();
            if (label == null || label.length() == 0) {
                label = entry.getURL().toString();
            }
            return label;
        }

        public IQueryUpdateSiteAdapter getQuerySearchSite() {
            return this.adapter;
        }

        private boolean isBroken() {
            try {
                IStatus status = SiteManager.getLocalSite().getFeatureStatus(this.candidate);
                return status.getSeverity() == 4;
            }
            catch (CoreException coreException) {
                return false;
            }
        }

        private boolean isMissingOptionalChildren(IFeature feature) {
            try {
                IIncludedFeatureReference[] children = feature.getIncludedFeatureReferences();
                int i = 0;
                while (i < children.length) {
                    block6: {
                        IIncludedFeatureReference ref = children[i];
                        try {
                            IFeature child = ref.getFeature(null);
                            if (this.isMissingOptionalChildren(child)) {
                                return true;
                            }
                        }
                        catch (CoreException coreException) {
                            if (!ref.isOptional()) break block6;
                            return FeatureHierarchyElement.hasOlderVersion(ref);
                        }
                    }
                    ++i;
                }
            }
            catch (CoreException coreException) {}
            return false;
        }

        public void run(ISite site, String[] categoriesToSkip, IUpdateSearchFilter filter, IUpdateSearchResultCollector collector, IProgressMonitor monitor) {
            ArrayList<Hit> hits = new ArrayList<Hit>();
            boolean broken = this.isBroken();
            boolean missingOptionalChildren = false;
            if (!broken) {
                missingOptionalChildren = this.isMissingOptionalChildren(this.candidate);
            }
            ISiteFeatureReference[] refs = site.getFeatureReferences();
            monitor.beginTask("", refs.length + 1);
            ArrayList<IInstallFeatureOperation> updateJobs = new ArrayList<IInstallFeatureOperation>();
            int i = 0;
            while (i < refs.length) {
                block15: {
                    block14: {
                        ISiteFeatureReference ref = refs[i];
                        try {
                            if (UpdatesSearchCategory.this.isNewerVersion(this.candidate.getVersionedIdentifier(), ref.getVersionedIdentifier())) {
                                Hit h = new Hit(this.candidate, ref);
                                hits.add(h);
                                IInstallFeatureOperation job = h.getJob();
                                if (job != null) {
                                    updateJobs.add(job);
                                }
                                break block14;
                            }
                            if ((broken || missingOptionalChildren) && this.candidate.getVersionedIdentifier().equals(ref.getVersionedIdentifier())) {
                                hits.add(new Hit(this.candidate, ref));
                                break block15;
                            }
                            if (!UpdatesSearchCategory.this.isPatch(this.candidate, ref)) break block14;
                            hits.add(new Hit(this.candidate, (IFeatureReference)ref, true));
                            break block15;
                        }
                        catch (CoreException coreException) {}
                    }
                    monitor.worked(1);
                    if (monitor.isCanceled()) {
                        return;
                    }
                }
                ++i;
            }
            int n = 0;
            while (n < updateJobs.size()) {
                IInstallFeatureOperation job = (IInstallFeatureOperation)updateJobs.get(n);
                IFeature newCandidate = job.getFeature();
                int i2 = 0;
                while (i2 < refs.length) {
                    ISiteFeatureReference ref = refs[i2];
                    if (UpdatesSearchCategory.this.isPatch(newCandidate, ref)) {
                        Hit h = new Hit(newCandidate, (IFeatureReference)ref, job);
                        hits.add(h);
                    } else if (monitor.isCanceled()) {
                        return;
                    }
                    ++i2;
                }
                ++n;
            }
            if (hits.size() > 0) {
                UpdatesSearchCategory.this.collectValidHits(hits, filter, collector);
            }
            monitor.worked(1);
            monitor.done();
        }
    }
}

