/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.standalone;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.update.configuration.IConfiguredSite;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.core.ISite;
import org.eclipse.update.core.SiteManager;
import org.eclipse.update.core.Utilities;
import org.eclipse.update.core.VersionedIdentifier;
import org.eclipse.update.internal.configurator.UpdateURLDecoder;
import org.eclipse.update.internal.core.Policy;
import org.eclipse.update.internal.core.UpdateCore;
import org.eclipse.update.internal.operations.DuplicateConflictsValidator;
import org.eclipse.update.internal.operations.UpdateUtils;
import org.eclipse.update.internal.search.SiteSearchCategory;
import org.eclipse.update.operations.IBatchOperation;
import org.eclipse.update.operations.IInstallFeatureOperation;
import org.eclipse.update.operations.OperationsManager;
import org.eclipse.update.search.BackLevelFilter;
import org.eclipse.update.search.EnvironmentFilter;
import org.eclipse.update.search.IUpdateSearchResultCollector;
import org.eclipse.update.search.UpdateSearchRequest;
import org.eclipse.update.search.UpdateSearchScope;
import org.eclipse.update.search.VersionedIdentifiersFilter;
import org.eclipse.update.standalone.ScriptedCommand;
import org.eclipse.update.standalone.StandaloneUpdateApplication;

public class InstallCommand
extends ScriptedCommand {
    private IConfiguredSite targetSite;
    private UpdateSearchRequest searchRequest;
    private UpdateSearchResultCollector collector;
    private URL remoteSiteURL;
    private String featureId;
    private String version;

    public InstallCommand(String featureId, String version, String fromSite, String toSite, String verifyOnly) throws Exception {
        super(verifyOnly);
        try {
            int i;
            IConfiguredSite[] sites;
            this.featureId = featureId;
            this.version = version;
            this.remoteSiteURL = new URL(UpdateURLDecoder.decode((String)fromSite, (String)"UTF-8"));
            this.targetSite = this.getTargetSite(toSite);
            if (this.targetSite == null) {
                this.targetSite = UpdateUtils.getSiteWithFeature(this.getConfiguration(), featureId);
            }
            if (this.targetSite == null) {
                sites = this.getConfiguration().getConfiguredSites();
                i = 0;
                while (i < sites.length) {
                    if (sites[i].isProductSite() && sites[i].isUpdatable()) {
                        this.targetSite = sites[i];
                        break;
                    }
                    ++i;
                }
            }
            if (this.targetSite == null) {
                sites = this.getConfiguration().getConfiguredSites();
                i = 0;
                while (i < sites.length) {
                    if (sites[i].isUpdatable()) {
                        this.targetSite = sites[i];
                        break;
                    }
                    ++i;
                }
            }
            if (this.targetSite == null) {
                throw Utilities.newCoreException(String.valueOf(Policy.bind("Standalone.cannotInstall")) + featureId + " " + version, null);
            }
            UpdateSearchScope searchScope = new UpdateSearchScope();
            searchScope.addSearchSite("remoteSite", this.remoteSiteURL, new String[0]);
            this.searchRequest = new UpdateSearchRequest(new SiteSearchCategory(), searchScope);
            VersionedIdentifier vid = new VersionedIdentifier(featureId, version);
            this.searchRequest.addFilter(new VersionedIdentifiersFilter(new VersionedIdentifier[]{vid}));
            this.searchRequest.addFilter(new EnvironmentFilter());
            this.searchRequest.addFilter(new BackLevelFilter());
            this.collector = new UpdateSearchResultCollector();
        }
        catch (MalformedURLException e) {
            throw e;
        }
        catch (CoreException e) {
            throw e;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean run(IProgressMonitor monitor) {
        block12: {
            block11: {
                block10: {
                    try {
                        try {
                            IInstallFeatureOperation[] operations;
                            block13: {
                                block15: {
                                    block14: {
                                        monitor.beginTask(Policy.bind("Standalone.installing"), 4);
                                        this.searchRequest.performSearch(this.collector, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                                        operations = this.collector.getOperations();
                                        if (operations == null) throw Utilities.newCoreException(String.valueOf(Policy.bind("Standalone.feature")) + this.featureId + " " + this.version + Policy.bind("Standalone.notFound") + this.remoteSiteURL + Policy.bind("Standalone.newerInstalled"), null);
                                        if (operations.length == 0) {
                                            throw Utilities.newCoreException(String.valueOf(Policy.bind("Standalone.feature")) + this.featureId + " " + this.version + Policy.bind("Standalone.notFound") + this.remoteSiteURL + Policy.bind("Standalone.newerInstalled"), null);
                                        }
                                        ArrayList conflicts = DuplicateConflictsValidator.computeDuplicateConflicts(operations, this.getConfiguration());
                                        if (conflicts != null) {
                                            throw Utilities.newCoreException(Policy.bind("Standalone.duplicate"), null);
                                        }
                                        if (!this.isVerifyOnly()) break block13;
                                        if (operations == null) break block14;
                                        if (operations.length != 0) break block15;
                                    }
                                    Object var6_5 = null;
                                    break block10;
                                }
                                IStatus status = OperationsManager.getValidator().validatePendingChanges(operations);
                                if (status != null && status.getCode() == 4) {
                                    throw new CoreException(status);
                                }
                                break block11;
                            }
                            IBatchOperation installOperation = OperationsManager.getOperationFactory().createBatchInstallOperation(operations);
                            try {
                                installOperation.execute((IProgressMonitor)new SubProgressMonitor(monitor, 3), this);
                                System.out.println(String.valueOf(Policy.bind("Standalone.feature")) + this.featureId + " " + this.version + Policy.bind("Standalone.installed"));
                                break block12;
                            }
                            catch (Exception e) {
                                throw Utilities.newCoreException(String.valueOf(Policy.bind("Standalone.cannotInstall")) + this.featureId + " " + this.version, e);
                            }
                        }
                        catch (CoreException ce) {
                            StandaloneUpdateApplication.exceptionLogged();
                            UpdateCore.log(ce);
                            Object var6_8 = null;
                            monitor.done();
                            return false;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var6_9 = null;
                        monitor.done();
                        throw throwable;
                    }
                }
                monitor.done();
                return false;
            }
            Object var6_6 = null;
            monitor.done();
            return true;
        }
        Object var6_7 = null;
        monitor.done();
        return true;
    }

    private IConfiguredSite getTargetSite(String toSite) throws Exception {
        URL toSiteURL;
        ISite site;
        if (toSite == null) {
            return null;
        }
        IConfiguredSite[] configuredSites = this.getConfiguration().getConfiguredSites();
        File sitePath = new File(toSite);
        File secondaryPath = sitePath.getName().equals("eclipse") ? null : new File(sitePath, "eclipse");
        int i = 0;
        while (i < configuredSites.length) {
            IConfiguredSite csite = configuredSites[i];
            if (csite.getSite().getURL().sameFile(sitePath.toURL())) {
                return csite;
            }
            if (secondaryPath != null && csite.getSite().getURL().sameFile(secondaryPath.toURL())) {
                return csite;
            }
            ++i;
        }
        if (!sitePath.exists()) {
            sitePath.mkdirs();
        }
        if ((site = SiteManager.getSite(toSiteURL = sitePath.toURL(), null)) == null) {
            throw new Exception(String.valueOf(Policy.bind("Standalone.noSite")) + toSite);
        }
        IConfiguredSite csite = site.getCurrentConfiguredSite();
        if (csite == null) {
            csite = this.getConfiguration().createConfiguredSite(sitePath);
            IStatus status = csite.verifyUpdatableStatus();
            if (!status.isOK()) {
                throw new CoreException(status);
            }
            this.getConfiguration().addConfiguredSite(csite);
            return csite;
        }
        return csite;
    }

    class UpdateSearchResultCollector
    implements IUpdateSearchResultCollector {
        private ArrayList operations = new ArrayList();

        UpdateSearchResultCollector() {
        }

        public void accept(IFeature feature) {
            if (feature.getVersionedIdentifier().getIdentifier().equals(InstallCommand.this.featureId) && feature.getVersionedIdentifier().getVersion().toString().equals(InstallCommand.this.version)) {
                this.operations.add(OperationsManager.getOperationFactory().createInstallOperation(InstallCommand.this.targetSite, feature, null, null, null));
            }
        }

        public IInstallFeatureOperation[] getOperations() {
            IInstallFeatureOperation[] opsArray = new IInstallFeatureOperation[this.operations.size()];
            this.operations.toArray(opsArray);
            return opsArray;
        }
    }
}

