/*******************************************************************************
 * Copyright (c) 2000, 2004 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.pde.ui;

/**
 * In addition to field data from the 'New Project' wizard pages, this interface
 * provides choices made by the user that are unique to creating a new plug-in
 * project.
 * 
 * @since 3.0
 */
public interface IPluginFieldData extends IFieldData {
	/**
	 * The class name field.
	 * 
	 * @return the name of the plug-in class
	 */
	String getClassname();
	/**
	 * UI plug-in selection.
	 * 
	 * @return <code>true</code> if the plug-in contains UI code and
	 *         extensions, <code>false</code> otherwise.
	 */
	boolean isUIPlugin();
	/**
	 * Plug-in class generation selection.
	 * 
	 * @return <code>true</code> if the plug-in class is to be generated by
	 *         the plug-in wizard, <code>false</code> otherwise.
	 */
	boolean doGenerateClass();
	
	/**
	 * Rich Client Application selection.
	 * 
	 * @since 3.1
	 * @return <code>true</code> if an RCP application is to be generated by
	 *         the plug-in wizard, <code>false</code> otherwise.
	 */
	boolean isRCPApplicationPlugin();
	
	/**
	 * The RCP application id name field.
	 * 
	 * @since 3.1
	 * @return the name of the RCP application ID
	 */
	String getApplicationID();

	/**
	 * The RCP application class name field.
	 * 
	 * @since 3.1
	 * @return the name of the RCP application class
	 */
	String getApplicationClassname();
}
