package bilab;

import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IWorkbenchPart;

import org.eclipse.swt.*;
import org.eclipse.swt.graphics.*;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.*;
import org.eclipse.swt.custom.*;

import scigol.TypeSpec;



// simple tree viewer  
public class TreeViewer extends ViewerBase
{
  public TreeViewer(Composite parent) 
  {
    top = new Composite(parent, SWT.NONE);
    top.setLayout(new FillLayout());
    
    child = optionalControlsComposite(top);
    
    scrolled = new ScrolledComposite(child, SWT.H_SCROLL | SWT.V_SCROLL | SWT.BORDER);
    scrolled.setAlwaysShowScrollBars(false);
    input = null;
    viewer = null;
    label = new Label(scrolled, SWT.NONE);
    scrolled.setContent(label);
  }

  tree input;
  PictureViewer viewer;
  Label label;
  Composite top;
  Composite child;
  ScrolledComposite scrolled;
  
  
  
  private picture renderTree(tree t)
  {
    Object[] args = new Object[1];
    args[0] = t;
    
    Object result = BilabPlugin.getAddOnManager().callExternalFunction("bilab.phylip","drawtree",args);
    result = TypeSpec.unwrapAny(result);
    if (!(result instanceof picture)) Notify.devError(this,"expected picture");
    return (picture)result;
  }
  
 

  public Point preferedSize()
  {
    if (viewer != null)
      return viewer.preferedSize();
    return top.computeSize(SWT.DEFAULT, SWT.DEFAULT);
  }

  public Point maximumSize()
  {
    if (viewer != null)
      return viewer.maximumSize();
    return top.computeSize(SWT.DEFAULT, SWT.DEFAULT);
  }


  public String get_title()
  {
    if (input != null)
      return input.get_ShortText();
    else
      return "<no tree>";
  }

  public String get_description()
  {
    if (input != null)
      return input.get_DetailText();
    else
      return "";
  }

  
  public void dispose()
  {
  }
  
  
  public Control getControl()
  {
    return top;
  }

  public Object getInput()
  {
    return input;
  }

  public void refresh()
  {
    if (viewer == null) {
      // update label
      if (input != null) {
        if (input instanceof IUserText) 
          label.setText(((IUserText)input).get_DetailText());
        else 
          label.setText(input.toString());
      }
      else
        label.setText("<no tree>");
    } 
    else { // update viewer
      
      picture treePicture = renderTree(input);
      
      viewer.setInput(treePicture); 
      viewer.refresh();
    }
    top.layout(true);
    top.redraw();
  }

  public void setInput(Object input)
  {
    input = TypeSpec.unwrapAnyOrNum(input);
    
    if (input == this.input) return; // didn't change
    
    if (!(input instanceof tree)) input=null;
    
    if (input != null) { 
      this.input = (tree)input;
    }
    else
      this.input = null;

    //  first, dispose of the current viewer, if any
    if (!child.isDisposed()) {
      child.dispose();
    }
    if (viewer != null) {
      viewer.dispose();
      viewer = null;
    }
    
    child = optionalControlsComposite(top);
    scrolled = new ScrolledComposite(child, SWT.H_SCROLL | SWT.V_SCROLL | SWT.BORDER);
    scrolled.setAlwaysShowScrollBars(false);
    //child.setExpandHorizontal(true);
    
    if (input != null) {
      viewer = new PictureViewer(scrolled);
    }
    
    if (viewer == null) { // no viewer found, use Label
      label = new Label(scrolled, SWT.NONE);
      scrolled.setContent(label);
    }
    else
      scrolled.setContent(viewer.getControl());
    
    refresh();
  }
  
  
  public ISelection getSelection()
  {
    if (viewer != null)
      return viewer.getSelection(); 
    return StructuredSelection.EMPTY;
  }
  
  public void setSelection(ISelection selection, boolean reveal)
  {
    if (viewer != null)
      viewer.setSelection(selection,reveal);
  }
  
  

  public void selectionChanged(IWorkbenchPart part, ISelection selection)
  {
  }

}
