package bilab;

import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.application.*;
import org.eclipse.ui.*;
import org.eclipse.ui.actions.*;
import org.eclipse.jface.action.*;
import org.eclipse.ui.actions.ActionFactory.IWorkbenchAction;


public class BilabWorkbenchAdvisor extends WorkbenchAdvisor {
  
  
  
  
  public String getInitialWindowPerspectiveId() {
    return "bilab.consolePerspective";
  }
  
  public void preWindowOpen(IWorkbenchWindowConfigurer configurer) {
    super.preWindowOpen(configurer);
//    configurer.setInitialSize(new Point(1600-48, 1200-48));
    configurer.setInitialSize(new Point(1280-48, 1024-48));
    configurer.setShowCoolBar(true);
    configurer.setShowStatusLine(true);
    configurer.setShowMenuBar(true);
    configurer.setShowPerspectiveBar(true);
    configurer.setShowProgressIndicator(true);
    configurer.setTitle("BiLab - Interactive Workbench for Computational Biology");
  }
  
  
  private static final String ACTION_BUILDER = "ActionBuilder";
  
  
  public void fillActionBars(IWorkbenchWindow window, IActionBarConfigurer configurer, int flags)
  {
    BilabActionBuilder actionBuilder = null;
    IWorkbenchWindowConfigurer windowConfigurer = getWorkbenchConfigurer().getWindowConfigurer(window);

    actionBuilder = (BilabActionBuilder)windowConfigurer.getData(ACTION_BUILDER);
    if (actionBuilder == null)
      actionBuilder = new BilabActionBuilder(window);

    if ((flags & FILL_PROXY) != 0) {
      // Filling in fake actionbars
      if ((flags & FILL_MENU_BAR) != 0)
        actionBuilder.populateMenuBar(configurer);
      if ((flags & FILL_COOL_BAR) != 0)
        actionBuilder.populateCoolBar(configurer);
    }
    else {
      windowConfigurer.setData(ACTION_BUILDER, actionBuilder);
      actionBuilder.makeAndPopulateActions(getWorkbenchConfigurer(), configurer);
    }
  }
  
  
  public void eventLoopException(Throwable t)
  {
    String m = t.getMessage();
    if (t==null) {
      t = t.getCause();
      m = t.getMessage();
    }
    if (m==null) m = t.getClass().toString();
    
    Notify.userWarning(this,"an exception occured within the Bilab interface:"+m);
    t.printStackTrace(); ///!!! appropriate?
  }
  
  
  
}
