/*
   math.h - mathematical functions

   Author : Michael Stumpf
            Michael.Stumpf@t-online.de

   __ATTR_CONST__ added by marekm@linux.org.pl for functions
   that "do not examine any values except their arguments, and have
   no effects except the return value", for better optimization by gcc.
 */

#ifndef __MATH_H
#define __MATH_H

#define M_PI 3.141592653589793238462643
#define M_SQRT2 1.4142135623730950488016887

#ifndef __ATTR_CONST__
#define __ATTR_CONST__ __attribute__((__const__))
#endif

#ifdef __cplusplus
extern "C" {
#endif
	
extern double cos(double) __ATTR_CONST__;
extern double fabs(double) __ATTR_CONST__;
#if 0
/* fabs seems to be built in already */
extern inline double fabs( double __x )
  { double __res;
    __asm__ __volatile__ ("andi %D0,0x7F \n\t"
		: "=d" (__res) : "0" (__x) );
    return __res;
  }
#endif
extern double fmod(double, double) __ATTR_CONST__;
extern double modf(double, double *);
extern double sin(double) __ATTR_CONST__;
extern double sqrt(double) __ATTR_CONST__;
extern double tan(double) __ATTR_CONST__;
extern double floor(double) __ATTR_CONST__;
extern double ceil(double) __ATTR_CONST__;
extern double frexp(double, int *);
extern double ldexp(double,int) __ATTR_CONST__;
extern double exp(double) __ATTR_CONST__;
extern double cosh(double) __ATTR_CONST__;
extern double sinh(double) __ATTR_CONST__;
extern double tanh(double) __ATTR_CONST__;
extern double acos(double) __ATTR_CONST__;
extern double asin(double) __ATTR_CONST__;
extern double atan(double) __ATTR_CONST__;
extern double atan2(double, double) __ATTR_CONST__;
extern double log(double) __ATTR_CONST__;
extern double log10(double) __ATTR_CONST__;
extern double pow(double, double) __ATTR_CONST__;
extern double strtod(const char *s, char **endptr);

/* non-standard functions */
extern double square(double) __ATTR_CONST__;
extern double inverse(double) __ATTR_CONST__;

#ifdef __cplusplus
}
#endif

#endif /* _MATH_H */

