/*
     kalc: A Scientific RPN Calculator
     Copyright (C) 1999-2000 Eduardo M Kalinowski (ekalin@iname.com)

     This program is free software. You may redistribute it, but only in
     its whole, unmodified form. You are allowed to make changes to this
     program, but you must not redistribute the changed version.

     This program is distributed in the hope it will be useful, but there
     is no warranty.

     For details, see the COPYING file.
*/


/***********************************************************************
 * Memory structure:                                                   *
 *                                                                     *
 * The memory is a stack, growing upward. The bottommost level         *
 * is the global memory area, and is always present. Upper levels are  *
 * temporary environments (only present during the execution of a      *
 * program. Names are searched from the topmost level downward.        *
 *                                                                     *
 * Each level is a hash table, whose number of buckets is              *
 * defined by the HASHBUCKETS macro defined below. Each bucket is a    *
 * pointer to a hashBucket structure, which stores the name of the     *
 * memory entry, a pointer to the object stored and a pointer to the   *
 * next hashBucket structure, which forms a singly linked list. A NULL *
 * pointer ends the linked list. The first object in each bucket is    *
 * actually just a sentinel.                                           *
 *                                                                     *
 * As objects are stored, they are added to the end of the linked      *
 * list.                                                               *
 ***********************************************************************/

#ifndef __MEM_H
#define __MEM_H 1

/* Number of stack levels */
#define MEMLEVELS 10

/* Number of hash buckets in each level */
#define HASHBUCKETS 211


/* Magic version identifier -- for object */
#define MAGICOBJVER    "Oalc220"
#define MAGICOBJVER210 "Oalc210"
#define MAGICOBJVER200 "Oalc200"


/* The hash bucket structure */
struct tagHashbucket {
  char *name;
  Object *obj;
  struct tagHashbucket *next;
};
typedef struct tagHashbucket hashBucket;


/* Functions */
Object *storeObject(char *name, Object *objp);
void diskStoObject(char *name, Object *objp);
Object *recallObject(char *name);
Object *diskRclObject(char *name);
int _f_cd(Object n);
Object *purgeObject(char *name);
hashBucket *getLastPointer(unsigned long hashCode, int level);
hashBucket *getMemoryContents(char *name, unsigned long hashCode);
hashBucket *getPreviousPointer(char *name, unsigned long hashCode);
unsigned long getHashCode(char *name);

#endif /* __MEM_H */
