#include "diagramm.h"
#define ANZAHL 19
#define AKLASSEN 100

const int __centrx=335;
const int __dx=300;    // Breite des Diagramms von Mitte aus
const int __dy=6;       // Hoehe der Balken

diagramm::diagramm( int u,int v, QWidget* parent, const char* name, WFlags fl )  : QFrame( parent, name, fl )
{
    frau=new float[AKLASSEN];
    mann=new float[AKLASSEN];
    ix=u;
    iy=v; 
    step=0;
    setFixedSize(u,v);
    
}


void diagramm::set_fields(float *x, float *y,int step1)
{
    step=step1;
    for(int i=0; i<AKLASSEN; i++){
	frau[i]=x[i];	
	mann[i]=y[i];	
       // cerr << i << " : " << frau[i] << " " << mann[i] << endl;
    }
}
	

void diagramm::paintEvent(QPaintEvent *)
{
  // Festlegung der Koordinatenachsen 
  QPainter p(this);
  p.fillRect(0,0,ix,iy,QBrush(white));
  QString ueberschrift="Age structure: males=blue, females=red";
  p.drawText(200,20,ueberschrift);
  QBrush brushw(red);  // weibl Marker
  QBrush brushm(blue);  // maennl Marker
  QBrush brush(black);
  mmax=fmax=0.0;
  for(int i=0; i<AKLASSEN; i++){
      if(mmax<mann[i])mmax=mann[i];
      if(fmax<frau[i])fmax=frau[i];
  }
  float scale;
  fmax>mmax ? scale=fmax : scale=mmax;
  for(int i=0; i<AKLASSEN; i++){
      p.fillRect(__centrx,(iy-50)-i*__dy,(int)(__dx*frau[i]/scale),__dy,brushw);
      p.fillRect(__centrx,(iy-50)-i*__dy,(int)(-__dx*mann[i]/scale),__dy,brushm);
  }
  p.setBrush(brush);
  p.drawLine(35,(iy-50+__dy),ix-35,(iy-50+__dy));
  // p.drawLine(35,60,35,450);
  QString s1;
  for(int i=0; i<ANZAHL; i++){
     s1.setNum(i*5);
     p.drawText(10,(iy-50)-i*__dy*5,s1);
  }
  s1.setNum(mmax);
  p.drawText(60,(iy-10),s1);
  s1.setNum(fmax);
  p.drawText(ix-90,(iy-10),s1);
  s1.setNum(step);
  p.drawText(45,50,"Step:");
  p.drawText(75,50,s1);
}


