// Please see the README file or the LEGAL NOTES-section in the manual before modifying, compiling or using 'xmrm'
//   Idea: Manfred Kopp
//   Programming: Gerhard Waldhr, Andreas Artmann

#include <stdio.h>
#include <malloc.h>
#include <errno.h>
#include <math.h>

#define TRUE 1
#define FALSE 0

#define MAX_PIC_NUM 999

#define MORPH_WARP   0
#define MORPH_MORPH  1
#define MORPH_WAVE   2
#define MORPH_AREA   3

#define VEC_NOSET     0
#define VEC_SET       1
#define VEC_DRAWSTART 2
#define VEC_DRAWEND   3
#define VEC_CLEAR     4
#define VEC_SEARCH    5
#define VEC_NOSEARCH  6

#define DRAW_NOTHING    0
#define DRAW_SRCVECTORS 1
#define DRAW_DSTVECTORS 2
#define ACTIVE_SRC      0
#define ACTIVE_DST      1
#define EDIT_NEW        0
#define EDIT_LINE       1
#define EDIT_REPLACE    2
#define EDIT_DELETE     3

#define CO_OK    0
#define CO_SHOW  1
#define CO_HIDE  2

#define Q_SEARCH_RAD  30*30
#define CIRC_RAD      8
#define ARROW_V       12
#define ARROW_N       4
#define POINT_SIZE    10
#define AREA_MED      128
#define BIAS_FACTOR   0.95
#define WAVE_RTS      100

#define MAX_SIZE_X    4000
#define MAX_SIZE_Y    3000
#define MAX_VEC       1000
#define MAX_LEVELS    10
#define MAX_PICLEVELS 20
#define MAX_PIC       1000
//#define MIN_DECOMP    1
#define SHOW_SIZE     240
#define SHOW_MAX      1024

#define WARP_A_MIN 0.01
#define WARP_A_MAX 100.0
#define WARP_B_MIN 0.5
#define WARP_B_MAX 2.0
#define WARP_P_MIN 0.0
#define WARP_P_MAX 1.0

#define SL_WAVE_MIN 0.01
#define SL_WAVE_MAX 0.99

#define CT_START_MIN 0.0
#define CT_START_MAX 999.0
#define CT_STEP_MIN 1.0
#define CT_STEP_MAX 10.0

#define AKIMA_MIN 3
#define AKIMA_MAX 10

#define PROGRAM_ID "XMRM Version 2.0"
#define PROJECT_FILE_V20_ID "[XMRM_Version_2.0_PROJECT_FILE]"
#define VECTOR_FILE_V20_ID "[XMRM_Version_2.0_VECTOR_FILE]"
#define VECTOR_FILE_V12_ID "[Multi Resolution Image Metamorphosis Vector File]" // for compatibility

#define BW -1 // Borderwidth of objects
#define ABW abs(BW) // absolute value of BW, needed for 'akima'- and 'wavelet-levels'-plots
