%global         package_version 1.4.0_master

%if 0%{?fedora} || 0%{?rhel} >= 8
%global with_python3 1
%else
%global with_python2 1
%endif

%{!?__python2: %global __python2 /usr/bin/python2}
%{!?python2_sitelib2: %global python2_sitelib %(%{__python2} -c "from distutils.sysconfig import get_python_lib; print (get_python_lib())")}

# Skips check since rhel default repos lack flake8
%if ! 0%{?rhel}
%{!?with_check:%global with_check 1}
%else
%{!?with_check:%global with_check 0}
%endif

# Default to skipping autoreconf.  Distros can change just this one line
# (or provide a command-line override) if they backport any patches that
# touch configure.ac or Makefile.am.
%{!?enable_autotools:%global enable_autotools 0}

%global modname engine_db_query

%global commit 0000000000000000000000000000000000000000
%global shortcommit %(c=%{commit}; echo ${c:0:7})

Name:           engine-db-query
Version:        1.4.0
Release:        0%{?release_suffix}%{?dist}
Summary:        A python module to query engine database
License:        GPLv2
Group:          System Environment/Libraries
URL:            https://ovirt.org/

Source0:        engine-db-query-%{package_version}.tar.gz

BuildArch:      noarch

BuildRequires: python2-devel
BuildRequires: python-setuptools

%if 0%{?with_check}
BuildRequires: python-tools
BuildRequires: python-flake8
%endif

# Autotools BuildRequires
%if 0%{?enable_autotools}
BuildRequires: autoconf
BuildRequires: automake
BuildRequires: gettext-devel
BuildRequires: libtool
%endif

%if 0%{?with_python3} && 0%{?with_check}
BuildRequires: python3-devel
BuildRequires: python3-setuptools
BuildRequires: python3-flake8
BuildRequires: python-tools
%endif

Requires: python-psycopg2

%{!?_licensedir:%global license %%doc}

%description
python engine-db-query is a python 2 library to manage data from ovirt database

%if 0%{?with_python3}
%package -n python3-engine-db-query
Summary: A python 3 module to manage engine database
Requires: python3-psycopg2

%description -n python3-engine-db-query
python engine-db-query is a python 3 library to manage data from ovirt database
%endif

%prep
%setup -q -n %{name}-%{package_version}

%build
%if 0%{?enable_autotools}
autoreconf -if
%endif

%if 0%{?with_python3}
%configure
%endif

%if 0%{?with_python2}
%configure --without-python3
%endif

make %{?_smp_mflags}

%install
make %{?_smp_mflags} install DESTDIR="%{buildroot}"

%check
%if 0%{?with_check}
make check-local
%endif

%if 0%{?with_python2}
%files
%license COPYING
%{_bindir}/engine-db-query
%dir %{python2_sitelib}/%{modname}
%{python2_sitelib}/%{modname}/*.py*
%{_mandir}/man8/*
%endif

%if 0%{?with_python3}
%files -n python3-engine-db-query
%license COPYING
%{_bindir}/engine-db-query
%dir %{python3_sitelib}/%{modname}
%{python3_sitelib}/%{modname}/*.py*
%{python3_sitelib}/%{modname}/__pycache__/*.py*
%{_mandir}/man8/*
%endif

%changelog
* Wed May 09 2018 Douglas Schilling Landgraf <dougsland@gmail.com> 1.0-0
- Initial take
