/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.internal.xml;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.ovirt.api.metamodel.runtime.util.ArrayListWithHref;
import org.ovirt.api.metamodel.runtime.xml.XmlReader;
import org.ovirt.engine.sdk4.internal.containers.GroupContainer;
import org.ovirt.engine.sdk4.internal.xml.XmlDomainReader;
import org.ovirt.engine.sdk4.internal.xml.XmlPermissionReader;
import org.ovirt.engine.sdk4.internal.xml.XmlRoleReader;
import org.ovirt.engine.sdk4.internal.xml.XmlTagReader;
import org.ovirt.engine.sdk4.types.Group;
import org.ovirt.engine.sdk4.types.Permission;

public class XmlGroupReader {
    public static Group readOne(XmlReader reader) {
        if (!reader.forward()) {
            return null;
        }
        GroupContainer object = new GroupContainer();
        block32: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String name = reader.getAttributeLocalName(i);
            String image = reader.getAttributeValue(i);
            switch (name) {
                case "href": {
                    object.href(image);
                    continue block32;
                }
                case "id": {
                    object.id(image);
                    continue block32;
                }
            }
        }
        reader.next();
        block33: while (reader.forward()) {
            String name;
            switch (name = reader.getLocalName()) {
                case "comment": {
                    object.comment(reader.readString());
                    continue block33;
                }
                case "description": {
                    object.description(reader.readString());
                    continue block33;
                }
                case "domain": {
                    object.domain(XmlDomainReader.readOne(reader));
                    continue block33;
                }
                case "domain_entry_id": {
                    object.domainEntryId(reader.readString());
                    continue block33;
                }
                case "name": {
                    object.name(reader.readString());
                    continue block33;
                }
                case "namespace": {
                    object.namespace(reader.readString());
                    continue block33;
                }
                case "permissions": {
                    object.permissions(XmlPermissionReader.readMany(reader));
                    continue block33;
                }
                case "roles": {
                    object.roles(XmlRoleReader.readMany(reader));
                    continue block33;
                }
                case "tags": {
                    object.tags(XmlTagReader.readMany(reader));
                    continue block33;
                }
                case "link": {
                    XmlGroupReader.readLink(reader, object);
                    continue block33;
                }
            }
            reader.skip();
        }
        reader.next();
        return object;
    }

    public static Iterator<Group> iterateMany(final XmlReader reader) {
        return new Iterator<Group>(){
            private boolean first = true;

            @Override
            public void remove() {
            }

            @Override
            public boolean hasNext() {
                if (this.first) {
                    if (!reader.forward()) {
                        return false;
                    }
                    reader.next();
                    this.first = false;
                }
                if (!reader.forward()) {
                    reader.next();
                    return false;
                }
                return true;
            }

            @Override
            public Group next() {
                Group next = XmlGroupReader.readOne(reader);
                if (next == null) {
                    throw new NoSuchElementException();
                }
                return next;
            }
        };
    }

    public static List<Group> readMany(XmlReader reader) {
        ArrayList<Group> list = new ArrayList<Group>();
        Iterator<Group> iterator = XmlGroupReader.iterateMany(reader);
        while (iterator.hasNext()) {
            list.add(iterator.next());
        }
        return list;
    }

    private static void readLink(XmlReader reader, GroupContainer object) {
        String rel = null;
        String href = null;
        block18: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String attrName = reader.getAttributeLocalName(i);
            String attrVal = reader.getAttributeValue(i);
            switch (attrName) {
                case "href": {
                    href = attrVal;
                    continue block18;
                }
                case "rel": {
                    rel = attrVal;
                    continue block18;
                }
                default: {
                    reader.skip();
                }
            }
        }
        if (href != null) {
            ArrayListWithHref<Permission> list = new ArrayListWithHref<Permission>();
            list.href(href);
            switch (rel) {
                case "permissions": {
                    object.permissions(list);
                    break;
                }
                case "roles": {
                    object.roles(list);
                    break;
                }
                case "tags": {
                    object.tags(list);
                    break;
                }
            }
        }
        reader.skip();
    }
}

