/*
Copyright (c) 2015 Red Hat, Inc.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package org.ovirt.engine.sdk4.types;

import java.lang.String;

/**
 * Describes how a disk is attached to a virtual machine.
 */
public interface DiskAttachment extends Identified {
    boolean active();
    
    boolean activePresent();
    
    boolean bootable();
    
    boolean bootablePresent();
    
    DiskInterface interface_();
    
    boolean interface_Present();
    
    String logicalName();
    
    boolean logicalNamePresent();
    
    boolean passDiscard();
    
    boolean passDiscardPresent();
    
    boolean usesScsiReservation();
    
    boolean usesScsiReservationPresent();
    
    Disk disk();
    
    boolean diskPresent();
    
    Template template();
    
    boolean templatePresent();
    
    Vm vm();
    
    boolean vmPresent();
    
}
