/*
Copyright (c) 2015 Red Hat, Inc.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package org.ovirt.engine.sdk4.types;


import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum StorageType {
    
    ISCSI,
    FCP,
    NFS,
    LOCALFS,
    POSIXFS,
    GLUSTERFS,
    GLANCE,
    CINDER;
    
    private static final Logger LOG = LoggerFactory.getLogger(StorageType.class);
    
    public String value() {
        return name().toLowerCase();
    }
    
    public static StorageType fromValue(String value) {
        try {
            return valueOf(value.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            LOG.error("The string '" + value + "' isn't a valid value for the 'StorageType' enumerated type. Valid values are: 'iscsi', 'fcp', 'nfs', 'localfs', 'posixfs', 'glusterfs', 'glance', 'cinder'.");
            return null;
        }
    }
    
}
