/*
Copyright (c) 2015 Red Hat, Inc.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package org.ovirt.engine.sdk4.types;

import java.lang.String;
import java.math.BigInteger;
import java.util.List;

/**
 * Type representing a host.
 */
public interface Host extends Identified {
    String address();
    
    boolean addressPresent();
    
    AutoNumaStatus autoNumaStatus();
    
    boolean autoNumaStatusPresent();
    
    Certificate certificate();
    
    boolean certificatePresent();
    
    Cpu cpu();
    
    boolean cpuPresent();
    
    HostDevicePassthrough devicePassthrough();
    
    boolean devicePassthroughPresent();
    
    Display display();
    
    boolean displayPresent();
    
    ExternalStatus externalStatus();
    
    boolean externalStatusPresent();
    
    HardwareInformation hardwareInformation();
    
    boolean hardwareInformationPresent();
    
    HostedEngine hostedEngine();
    
    boolean hostedEnginePresent();
    
    IscsiDetails iscsi();
    
    boolean iscsiPresent();
    
    KdumpStatus kdumpStatus();
    
    boolean kdumpStatusPresent();
    
    Ksm ksm();
    
    boolean ksmPresent();
    
    Version libvirtVersion();
    
    boolean libvirtVersionPresent();
    
    BigInteger maxSchedulingMemory();
    
    boolean maxSchedulingMemoryPresent();
    
    BigInteger memory();
    
    boolean memoryPresent();
    
    boolean numaSupported();
    
    boolean numaSupportedPresent();
    
    OperatingSystem os();
    
    boolean osPresent();
    
    boolean overrideIptables();
    
    boolean overrideIptablesPresent();
    
    BigInteger port();
    
    boolean portPresent();
    
    PowerManagement powerManagement();
    
    boolean powerManagementPresent();
    
    HostProtocol protocol();
    
    boolean protocolPresent();
    
    String rootPassword();
    
    boolean rootPasswordPresent();
    
    SeLinux seLinux();
    
    boolean seLinuxPresent();
    
    Spm spm();
    
    boolean spmPresent();
    
    Ssh ssh();
    
    boolean sshPresent();
    
    HostStatus status();
    
    boolean statusPresent();
    
    String statusDetail();
    
    boolean statusDetailPresent();
    
    VmSummary summary();
    
    boolean summaryPresent();
    
    TransparentHugePages transparentHugePages();
    
    boolean transparentHugePagesPresent();
    
    HostType type();
    
    boolean typePresent();
    
    boolean updateAvailable();
    
    boolean updateAvailablePresent();
    
    Version version();
    
    boolean versionPresent();
    
    List<AffinityLabel> affinityLabels();
    
    boolean affinityLabelsPresent();
    
    List<Agent> agents();
    
    boolean agentsPresent();
    
    Cluster cluster();
    
    boolean clusterPresent();
    
    List<Device> devices();
    
    boolean devicesPresent();
    
    ExternalHostProvider externalHostProvider();
    
    boolean externalHostProviderPresent();
    
    List<Hook> hooks();
    
    boolean hooksPresent();
    
    List<KatelloErratum> katelloErrata();
    
    boolean katelloErrataPresent();
    
    List<NetworkAttachment> networkAttachments();
    
    boolean networkAttachmentsPresent();
    
    List<Nic> nics();
    
    boolean nicsPresent();
    
    List<NumaNode> numaNodes();
    
    boolean numaNodesPresent();
    
    List<Permission> permissions();
    
    boolean permissionsPresent();
    
    List<Statistic> statistics();
    
    boolean statisticsPresent();
    
    List<StorageConnectionExtension> storageConnectionExtensions();
    
    boolean storageConnectionExtensionsPresent();
    
    List<HostStorage> storages();
    
    boolean storagesPresent();
    
    List<Tag> tags();
    
    boolean tagsPresent();
    
    List<UnmanagedNetwork> unmanagedNetworks();
    
    boolean unmanagedNetworksPresent();
    
}
