/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.internal.xml;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.ovirt.api.metamodel.runtime.util.ArrayListWithHref;
import org.ovirt.api.metamodel.runtime.xml.XmlReader;
import org.ovirt.engine.sdk4.internal.containers.OpenStackVolumeProviderContainer;
import org.ovirt.engine.sdk4.internal.xml.XmlCertificateReader;
import org.ovirt.engine.sdk4.internal.xml.XmlDataCenterReader;
import org.ovirt.engine.sdk4.internal.xml.XmlOpenStackVolumeTypeReader;
import org.ovirt.engine.sdk4.internal.xml.XmlOpenstackVolumeAuthenticationKeyReader;
import org.ovirt.engine.sdk4.internal.xml.XmlPropertyReader;
import org.ovirt.engine.sdk4.types.Certificate;
import org.ovirt.engine.sdk4.types.OpenStackVolumeProvider;
import org.ovirt.engine.sdk4.types.OpenStackVolumeType;
import org.ovirt.engine.sdk4.types.OpenstackVolumeAuthenticationKey;

public class XmlOpenStackVolumeProviderReader {
    public static OpenStackVolumeProvider readOne(XmlReader reader) {
        String name;
        if (!reader.forward()) {
            return null;
        }
        OpenStackVolumeProviderContainer object = new OpenStackVolumeProviderContainer();
        block42: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            name = reader.getAttributeLocalName(i);
            String image = reader.getAttributeValue(i);
            switch (name) {
                case "href": {
                    object.href(image);
                    continue block42;
                }
                case "id": {
                    object.id(image);
                    continue block42;
                }
            }
        }
        ArrayList<String[]> links = new ArrayList<String[]>();
        reader.next();
        block43: while (reader.forward()) {
            switch (name = reader.getLocalName()) {
                case "authentication_keys": {
                    object.authenticationKeys(XmlOpenstackVolumeAuthenticationKeyReader.readMany(reader));
                    continue block43;
                }
                case "authentication_url": {
                    object.authenticationUrl(reader.readString());
                    continue block43;
                }
                case "certificates": {
                    object.certificates(XmlCertificateReader.readMany(reader));
                    continue block43;
                }
                case "comment": {
                    object.comment(reader.readString());
                    continue block43;
                }
                case "data_center": {
                    object.dataCenter(XmlDataCenterReader.readOne(reader));
                    continue block43;
                }
                case "description": {
                    object.description(reader.readString());
                    continue block43;
                }
                case "name": {
                    object.name(reader.readString());
                    continue block43;
                }
                case "password": {
                    object.password(reader.readString());
                    continue block43;
                }
                case "properties": {
                    object.properties(XmlPropertyReader.readMany(reader));
                    continue block43;
                }
                case "requires_authentication": {
                    object.requiresAuthentication(reader.readBoolean());
                    continue block43;
                }
                case "tenant_name": {
                    object.tenantName(reader.readString());
                    continue block43;
                }
                case "url": {
                    object.url(reader.readString());
                    continue block43;
                }
                case "username": {
                    object.username(reader.readString());
                    continue block43;
                }
                case "volume_types": {
                    object.volumeTypes(XmlOpenStackVolumeTypeReader.readMany(reader));
                    continue block43;
                }
                case "link": {
                    String rel = reader.getAttributeValue("rel");
                    String href = reader.getAttributeValue("href");
                    if (rel != null && href != null) {
                        links.add(new String[]{rel, href});
                    }
                    reader.next();
                    continue block43;
                }
            }
            reader.skip();
        }
        if (links != null) {
            for (String[] link : links) {
                XmlOpenStackVolumeProviderReader.processLink(object, link);
            }
        }
        reader.next();
        return object;
    }

    public static Iterator<OpenStackVolumeProvider> iterateMany(final XmlReader reader) {
        return new Iterator<OpenStackVolumeProvider>(){
            private boolean first = true;

            @Override
            public void remove() {
            }

            @Override
            public boolean hasNext() {
                if (this.first) {
                    if (!reader.forward()) {
                        return false;
                    }
                    reader.next();
                    this.first = false;
                }
                if (!reader.forward()) {
                    reader.next();
                    return false;
                }
                return true;
            }

            @Override
            public OpenStackVolumeProvider next() {
                OpenStackVolumeProvider next = XmlOpenStackVolumeProviderReader.readOne(reader);
                if (next == null) {
                    throw new NoSuchElementException();
                }
                return next;
            }
        };
    }

    public static List<OpenStackVolumeProvider> readMany(XmlReader reader) {
        ArrayList<OpenStackVolumeProvider> list = new ArrayList<OpenStackVolumeProvider>();
        Iterator<OpenStackVolumeProvider> iterator = XmlOpenStackVolumeProviderReader.iterateMany(reader);
        while (iterator.hasNext()) {
            list.add(iterator.next());
        }
        return list;
    }

    private static void processLink(OpenStackVolumeProviderContainer object, String[] link) {
        String rel = link[0];
        String href = link[1];
        if (href != null) {
            switch (rel) {
                case "authenticationkeys": {
                    ArrayListWithHref<OpenstackVolumeAuthenticationKey> list = new ArrayListWithHref<OpenstackVolumeAuthenticationKey>(object.authenticationKeys());
                    list.href(href);
                    object.authenticationKeys(list);
                    break;
                }
                case "certificates": {
                    ArrayListWithHref<Certificate> list = new ArrayListWithHref<Certificate>(object.certificates());
                    list.href(href);
                    object.certificates(list);
                    break;
                }
                case "volumetypes": {
                    ArrayListWithHref<OpenStackVolumeType> list = new ArrayListWithHref<OpenStackVolumeType>(object.volumeTypes());
                    list.href(href);
                    object.volumeTypes(list);
                    break;
                }
            }
        }
    }
}

