/*
Copyright (c) 2015 Red Hat, Inc.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package org.ovirt.engine.sdk4.types;

import java.lang.String;
import java.math.BigInteger;

public interface LogicalUnit {
    String address();
    
    boolean addressPresent();
    
    BigInteger discardMaxSize();
    
    boolean discardMaxSizePresent();
    
    boolean discardZeroesData();
    
    boolean discardZeroesDataPresent();
    
    String diskId();
    
    boolean diskIdPresent();
    
    String id();
    
    boolean idPresent();
    
    BigInteger lunMapping();
    
    boolean lunMappingPresent();
    
    String password();
    
    boolean passwordPresent();
    
    BigInteger paths();
    
    boolean pathsPresent();
    
    BigInteger port();
    
    boolean portPresent();
    
    String portal();
    
    boolean portalPresent();
    
    String productId();
    
    boolean productIdPresent();
    
    String serial();
    
    boolean serialPresent();
    
    BigInteger size();
    
    boolean sizePresent();
    
    LunStatus status();
    
    boolean statusPresent();
    
    String storageDomainId();
    
    boolean storageDomainIdPresent();
    
    String target();
    
    boolean targetPresent();
    
    String username();
    
    boolean usernamePresent();
    
    String vendorId();
    
    boolean vendorIdPresent();
    
    String volumeGroupId();
    
    boolean volumeGroupIdPresent();
    
}
