/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.builders;

import java.math.BigInteger;
import org.ovirt.engine.sdk4.internal.containers.VcpuPinContainer;
import org.ovirt.engine.sdk4.types.VcpuPin;

public class VcpuPinBuilder {
    private String cpuSet;
    private BigInteger vcpu;

    public VcpuPinBuilder cpuSet(String newCpuSet) {
        this.cpuSet = newCpuSet;
        return this;
    }

    public VcpuPinBuilder vcpu(int newVcpu) {
        this.vcpu = BigInteger.valueOf(newVcpu);
        return this;
    }

    public VcpuPinBuilder vcpu(Integer newVcpu) {
        this.vcpu = newVcpu == null ? null : BigInteger.valueOf(newVcpu.longValue());
        return this;
    }

    public VcpuPinBuilder vcpu(long newVcpu) {
        this.vcpu = BigInteger.valueOf(newVcpu);
        return this;
    }

    public VcpuPinBuilder vcpu(Long newVcpu) {
        this.vcpu = newVcpu == null ? null : BigInteger.valueOf(newVcpu);
        return this;
    }

    public VcpuPinBuilder vcpu(BigInteger newVcpu) {
        this.vcpu = newVcpu;
        return this;
    }

    public VcpuPin build() {
        VcpuPinContainer container = new VcpuPinContainer();
        container.cpuSet(this.cpuSet);
        container.vcpu(this.vcpu);
        return container;
    }
}

