/*
Copyright (c) 2015 Red Hat, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package services;

import annotations.Area;
import org.ovirt.api.metamodel.annotations.In;
import org.ovirt.api.metamodel.annotations.InputDetail;
import org.ovirt.api.metamodel.annotations.Out;
import org.ovirt.api.metamodel.annotations.Service;
import types.NetworkAttachment;

import static org.ovirt.api.metamodel.language.ApiLanguage.COLLECTION;
import static org.ovirt.api.metamodel.language.ApiLanguage.optional;

@Service
@Area("Network")
public interface NetworkAttachmentService {
    interface Get {
        @Out NetworkAttachment attachment();
    }

    /**
     * Update the specified network attachment on the host.
     *
     * @author Ori Liel <oliel@redhat.com>
     * @date 18 Jan 2017
     * @status added
     */
    interface Update {
        @InputDetail
        default void inputDetail() {
            optional(attachment().properties()[COLLECTION].name());
            optional(attachment().properties()[COLLECTION].value());
            optional(attachment().ipAddressAssignments()[COLLECTION].assignmentMethod());
            optional(attachment().ipAddressAssignments()[COLLECTION].ip().address());
            optional(attachment().ipAddressAssignments()[COLLECTION].ip().gateway());
            optional(attachment().ipAddressAssignments()[COLLECTION].ip().netmask());
            optional(attachment().ipAddressAssignments()[COLLECTION].ip().version());
        }
        @In @Out NetworkAttachment attachment();

        /**
         * Indicates if the update should be performed asynchronously.
         */
        @In Boolean async();
    }

    interface Remove {
        /**
         * Indicates if the remove should be performed asynchronously.
         */
        @In Boolean async();
    }
}
