/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.builders;

import java.util.Date;
import org.ovirt.engine.sdk4.builders.ApiSummaryBuilder;
import org.ovirt.engine.sdk4.builders.ProductInfoBuilder;
import org.ovirt.engine.sdk4.builders.SpecialObjectsBuilder;
import org.ovirt.engine.sdk4.builders.UserBuilder;
import org.ovirt.engine.sdk4.internal.containers.ApiContainer;
import org.ovirt.engine.sdk4.types.Api;
import org.ovirt.engine.sdk4.types.ApiSummary;
import org.ovirt.engine.sdk4.types.ProductInfo;
import org.ovirt.engine.sdk4.types.SpecialObjects;
import org.ovirt.engine.sdk4.types.User;

public class ApiBuilder {
    private User authenticatedUser;
    private User effectiveUser;
    private ProductInfo productInfo;
    private SpecialObjects specialObjects;
    private ApiSummary summary;
    private Date time;

    public ApiBuilder authenticatedUser(User newAuthenticatedUser) {
        this.authenticatedUser = newAuthenticatedUser;
        return this;
    }

    public ApiBuilder authenticatedUser(UserBuilder newAuthenticatedUser) {
        this.authenticatedUser = newAuthenticatedUser == null ? null : newAuthenticatedUser.build();
        return this;
    }

    public ApiBuilder effectiveUser(User newEffectiveUser) {
        this.effectiveUser = newEffectiveUser;
        return this;
    }

    public ApiBuilder effectiveUser(UserBuilder newEffectiveUser) {
        this.effectiveUser = newEffectiveUser == null ? null : newEffectiveUser.build();
        return this;
    }

    public ApiBuilder productInfo(ProductInfo newProductInfo) {
        this.productInfo = newProductInfo;
        return this;
    }

    public ApiBuilder productInfo(ProductInfoBuilder newProductInfo) {
        this.productInfo = newProductInfo == null ? null : newProductInfo.build();
        return this;
    }

    public ApiBuilder specialObjects(SpecialObjects newSpecialObjects) {
        this.specialObjects = newSpecialObjects;
        return this;
    }

    public ApiBuilder specialObjects(SpecialObjectsBuilder newSpecialObjects) {
        this.specialObjects = newSpecialObjects == null ? null : newSpecialObjects.build();
        return this;
    }

    public ApiBuilder summary(ApiSummary newSummary) {
        this.summary = newSummary;
        return this;
    }

    public ApiBuilder summary(ApiSummaryBuilder newSummary) {
        this.summary = newSummary == null ? null : newSummary.build();
        return this;
    }

    public ApiBuilder time(Date newTime) {
        this.time = newTime == null ? null : new Date(newTime.getTime());
        return this;
    }

    public Api build() {
        ApiContainer container = new ApiContainer();
        container.authenticatedUser(this.authenticatedUser);
        container.effectiveUser(this.effectiveUser);
        container.productInfo(this.productInfo);
        container.specialObjects(this.specialObjects);
        container.summary(this.summary);
        container.time(this.time);
        return container;
    }
}

