/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.builders;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.ovirt.engine.sdk4.builders.CertificateBuilder;
import org.ovirt.engine.sdk4.builders.ExternalComputeResourceBuilder;
import org.ovirt.engine.sdk4.builders.ExternalDiscoveredHostBuilder;
import org.ovirt.engine.sdk4.builders.ExternalHostGroupBuilder;
import org.ovirt.engine.sdk4.builders.HostBuilder;
import org.ovirt.engine.sdk4.builders.PropertyBuilder;
import org.ovirt.engine.sdk4.internal.containers.ExternalHostProviderContainer;
import org.ovirt.engine.sdk4.types.Certificate;
import org.ovirt.engine.sdk4.types.ExternalComputeResource;
import org.ovirt.engine.sdk4.types.ExternalDiscoveredHost;
import org.ovirt.engine.sdk4.types.ExternalHostGroup;
import org.ovirt.engine.sdk4.types.ExternalHostProvider;
import org.ovirt.engine.sdk4.types.Host;
import org.ovirt.engine.sdk4.types.Property;

public class ExternalHostProviderBuilder {
    private String authenticationUrl;
    private List<Certificate> certificates;
    private String comment;
    private List<ExternalComputeResource> computeResources;
    private String description;
    private List<ExternalDiscoveredHost> discoveredHosts;
    private List<ExternalHostGroup> hostGroups;
    private List<Host> hosts;
    private String href;
    private String id;
    private String name;
    private String password;
    private List<Property> properties;
    private Boolean requiresAuthentication;
    private String url;
    private String username;

    public ExternalHostProviderBuilder authenticationUrl(String newAuthenticationUrl) {
        this.authenticationUrl = newAuthenticationUrl;
        return this;
    }

    public ExternalHostProviderBuilder certificates(List<Certificate> newCertificates) {
        if (newCertificates != null) {
            if (this.certificates == null) {
                this.certificates = new ArrayList<Certificate>(newCertificates);
            } else {
                this.certificates.addAll(newCertificates);
            }
        }
        return this;
    }

    public ExternalHostProviderBuilder certificates(Certificate ... newCertificates) {
        if (newCertificates != null) {
            if (this.certificates == null) {
                this.certificates = new ArrayList<Certificate>(newCertificates.length);
            }
            Collections.addAll(this.certificates, newCertificates);
        }
        return this;
    }

    public ExternalHostProviderBuilder certificates(CertificateBuilder ... newCertificates) {
        if (newCertificates != null) {
            if (this.certificates == null) {
                this.certificates = new ArrayList<Certificate>(newCertificates.length);
            }
            for (CertificateBuilder builder : newCertificates) {
                this.certificates.add(builder.build());
            }
        }
        return this;
    }

    public ExternalHostProviderBuilder comment(String newComment) {
        this.comment = newComment;
        return this;
    }

    public ExternalHostProviderBuilder computeResources(List<ExternalComputeResource> newComputeResources) {
        if (newComputeResources != null) {
            if (this.computeResources == null) {
                this.computeResources = new ArrayList<ExternalComputeResource>(newComputeResources);
            } else {
                this.computeResources.addAll(newComputeResources);
            }
        }
        return this;
    }

    public ExternalHostProviderBuilder computeResources(ExternalComputeResource ... newComputeResources) {
        if (newComputeResources != null) {
            if (this.computeResources == null) {
                this.computeResources = new ArrayList<ExternalComputeResource>(newComputeResources.length);
            }
            Collections.addAll(this.computeResources, newComputeResources);
        }
        return this;
    }

    public ExternalHostProviderBuilder computeResources(ExternalComputeResourceBuilder ... newComputeResources) {
        if (newComputeResources != null) {
            if (this.computeResources == null) {
                this.computeResources = new ArrayList<ExternalComputeResource>(newComputeResources.length);
            }
            for (ExternalComputeResourceBuilder builder : newComputeResources) {
                this.computeResources.add(builder.build());
            }
        }
        return this;
    }

    public ExternalHostProviderBuilder description(String newDescription) {
        this.description = newDescription;
        return this;
    }

    public ExternalHostProviderBuilder discoveredHosts(List<ExternalDiscoveredHost> newDiscoveredHosts) {
        if (newDiscoveredHosts != null) {
            if (this.discoveredHosts == null) {
                this.discoveredHosts = new ArrayList<ExternalDiscoveredHost>(newDiscoveredHosts);
            } else {
                this.discoveredHosts.addAll(newDiscoveredHosts);
            }
        }
        return this;
    }

    public ExternalHostProviderBuilder discoveredHosts(ExternalDiscoveredHost ... newDiscoveredHosts) {
        if (newDiscoveredHosts != null) {
            if (this.discoveredHosts == null) {
                this.discoveredHosts = new ArrayList<ExternalDiscoveredHost>(newDiscoveredHosts.length);
            }
            Collections.addAll(this.discoveredHosts, newDiscoveredHosts);
        }
        return this;
    }

    public ExternalHostProviderBuilder discoveredHosts(ExternalDiscoveredHostBuilder ... newDiscoveredHosts) {
        if (newDiscoveredHosts != null) {
            if (this.discoveredHosts == null) {
                this.discoveredHosts = new ArrayList<ExternalDiscoveredHost>(newDiscoveredHosts.length);
            }
            for (ExternalDiscoveredHostBuilder builder : newDiscoveredHosts) {
                this.discoveredHosts.add(builder.build());
            }
        }
        return this;
    }

    public ExternalHostProviderBuilder hostGroups(List<ExternalHostGroup> newHostGroups) {
        if (newHostGroups != null) {
            if (this.hostGroups == null) {
                this.hostGroups = new ArrayList<ExternalHostGroup>(newHostGroups);
            } else {
                this.hostGroups.addAll(newHostGroups);
            }
        }
        return this;
    }

    public ExternalHostProviderBuilder hostGroups(ExternalHostGroup ... newHostGroups) {
        if (newHostGroups != null) {
            if (this.hostGroups == null) {
                this.hostGroups = new ArrayList<ExternalHostGroup>(newHostGroups.length);
            }
            Collections.addAll(this.hostGroups, newHostGroups);
        }
        return this;
    }

    public ExternalHostProviderBuilder hostGroups(ExternalHostGroupBuilder ... newHostGroups) {
        if (newHostGroups != null) {
            if (this.hostGroups == null) {
                this.hostGroups = new ArrayList<ExternalHostGroup>(newHostGroups.length);
            }
            for (ExternalHostGroupBuilder builder : newHostGroups) {
                this.hostGroups.add(builder.build());
            }
        }
        return this;
    }

    public ExternalHostProviderBuilder hosts(List<Host> newHosts) {
        if (newHosts != null) {
            if (this.hosts == null) {
                this.hosts = new ArrayList<Host>(newHosts);
            } else {
                this.hosts.addAll(newHosts);
            }
        }
        return this;
    }

    public ExternalHostProviderBuilder hosts(Host ... newHosts) {
        if (newHosts != null) {
            if (this.hosts == null) {
                this.hosts = new ArrayList<Host>(newHosts.length);
            }
            Collections.addAll(this.hosts, newHosts);
        }
        return this;
    }

    public ExternalHostProviderBuilder hosts(HostBuilder ... newHosts) {
        if (newHosts != null) {
            if (this.hosts == null) {
                this.hosts = new ArrayList<Host>(newHosts.length);
            }
            for (HostBuilder builder : newHosts) {
                this.hosts.add(builder.build());
            }
        }
        return this;
    }

    public ExternalHostProviderBuilder href(String newHref) {
        this.href = newHref;
        return this;
    }

    public ExternalHostProviderBuilder id(String newId) {
        this.id = newId;
        return this;
    }

    public ExternalHostProviderBuilder name(String newName) {
        this.name = newName;
        return this;
    }

    public ExternalHostProviderBuilder password(String newPassword) {
        this.password = newPassword;
        return this;
    }

    public ExternalHostProviderBuilder properties(List<Property> newProperties) {
        if (newProperties != null) {
            if (this.properties == null) {
                this.properties = new ArrayList<Property>(newProperties);
            } else {
                this.properties.addAll(newProperties);
            }
        }
        return this;
    }

    public ExternalHostProviderBuilder properties(Property ... newProperties) {
        if (newProperties != null) {
            if (this.properties == null) {
                this.properties = new ArrayList<Property>(newProperties.length);
            }
            Collections.addAll(this.properties, newProperties);
        }
        return this;
    }

    public ExternalHostProviderBuilder properties(PropertyBuilder ... newProperties) {
        if (newProperties != null) {
            if (this.properties == null) {
                this.properties = new ArrayList<Property>(newProperties.length);
            }
            for (PropertyBuilder builder : newProperties) {
                this.properties.add(builder.build());
            }
        }
        return this;
    }

    public ExternalHostProviderBuilder requiresAuthentication(boolean newRequiresAuthentication) {
        this.requiresAuthentication = newRequiresAuthentication;
        return this;
    }

    public ExternalHostProviderBuilder requiresAuthentication(Boolean newRequiresAuthentication) {
        this.requiresAuthentication = newRequiresAuthentication;
        return this;
    }

    public ExternalHostProviderBuilder url(String newUrl) {
        this.url = newUrl;
        return this;
    }

    public ExternalHostProviderBuilder username(String newUsername) {
        this.username = newUsername;
        return this;
    }

    public ExternalHostProvider build() {
        ExternalHostProviderContainer container = new ExternalHostProviderContainer();
        container.authenticationUrl(this.authenticationUrl);
        container.certificates(this.certificates);
        container.comment(this.comment);
        container.computeResources(this.computeResources);
        container.description(this.description);
        container.discoveredHosts(this.discoveredHosts);
        container.hostGroups(this.hostGroups);
        container.hosts(this.hosts);
        container.href(this.href);
        container.id(this.id);
        container.name(this.name);
        container.password(this.password);
        container.properties(this.properties);
        container.requiresAuthentication(this.requiresAuthentication);
        container.url(this.url);
        container.username(this.username);
        return container;
    }
}

