/*
Copyright (c) 2015 Red Hat, Inc.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package org.ovirt.engine.sdk4.internal.xml;

import java.util.Iterator;
import org.ovirt.api.metamodel.runtime.xml.XmlWriter;
import org.ovirt.engine.sdk4.types.ApiSummary;

public class XmlApiSummaryWriter {
    
    public static void writeOne(ApiSummary object, XmlWriter writer) {
        writeOne(object, "api_summary", writer);
    }
    
    public static void writeOne(ApiSummary object, String tag, XmlWriter writer) {
        writer.writeStartElement(tag);
        if (object.hostsPresent()) {
            XmlApiSummaryItemWriter.writeOne(object.hosts(), "hosts", writer);
        }
        if (object.storageDomainsPresent()) {
            XmlApiSummaryItemWriter.writeOne(object.storageDomains(), "storage_domains", writer);
        }
        if (object.usersPresent()) {
            XmlApiSummaryItemWriter.writeOne(object.users(), "users", writer);
        }
        if (object.vmsPresent()) {
            XmlApiSummaryItemWriter.writeOne(object.vms(), "vms", writer);
        }
        writer.writeEndElement();
    }
    
    public static void writeMany(Iterator<ApiSummary> list, XmlWriter writer) {
        writeMany(list, "api_summary", "api_summaries", writer);
    }
    
    public static void writeMany(Iterator<ApiSummary> list, String singular, String plural, XmlWriter writer) {
        writer.writeStartElement(plural);
        while (list.hasNext()) {
            XmlApiSummaryWriter.writeOne(list.next(), singular, writer);
        }
        writer.writeEndElement();
    }
    
}

