.\" Copyright 1993 X Consortium
.\"
.\" Permission is hereby granted, free of charge, to any person obtaining
.\" a copy of this software and associated documentation files (the
.\" "Software"), to deal in the Software without restriction, including
.\" without limitation the rights to use, copy, modify, merge, publish,
.\" distribute, sublicense, and/or sell copies of the Software, and to
.\" permit persons to whom the Software is furnished to do so, subject to
.\" the following conditions:
.\"
.\" The above copyright notice and this permission notice shall be
.\" included in all copies or substantial portions of the Software.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
.\" EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
.\" MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
.\" IN NO EVENT SHALL THE X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR
.\" OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
.\" ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
.\" OTHER DEALINGS IN THE SOFTWARE.
.\"
.\" Except as contained in this notice, the name of the X Consortium shall
.\" not be used in advertising or otherwise to promote the sale, use or
.\" other dealings in this Software without prior written authorization
.\" from the X Consortium.
.\"
.ds tk X Toolkit
.ds xT X Toolkit Intrinsics \- C Language Interface
.ds xI Intrinsics
.ds xW X Toolkit Athena Widgets \- C Language Interface
.ds xL Xlib \- C Language X Interface
.ds xC Inter-Client Communication Conventions Manual
.ds Rn 3
.ds Vn 2.2
.hw XtDirect-Convert wid-get
.na
.TH XtConvert __libmansuffix__ __xorgversion__ "XT COMPATIBILITY FUNCTIONS"
.SH NAME
XtConvert, XtDirectConvert \- invoke resource converters
.SH SYNTAX
#include <X11/Intrinsic.h>
.HP
void XtConvert(Widget \fIw\fP,
const char *\fIfrom_type\fP, XrmValuePtr \fIfrom\fP,
const char *\fIto_type\fP, XrmValuePtr \fIto_return\fP);
.HP
void XtDirectConvert(XtConverter \fIconverter\fP, XrmValuePtr \fIargs\fP,
Cardinal \fInum_args\fP, XrmValuePtr \fIfrom\fP, XrmValuePtr \fIto_return\fP);
.SH ARGUMENTS
.IP \fIargs\fP 1i
Specifies the argument list that contains the additional arguments needed to perform the conversion (often NULL).
.IP \fIconverter\fP 1i
Specifies the conversion procedure that is to be called.
.IP \fIfrom\fP 1i
Specifies the value to be converted.
.IP \fIfrom_type\fP 1i
Specifies the source type.
.IP \fInum_args\fP 1i
Specifies the number of additional arguments (often zero).
.IP \fIto_type\fP 1i
Specifies the destination type.
.IP \fIto_return\fP 1i
Returns the converted value.
.IP \fIw\fP 1i
Specifies the widget to use for additional arguments (if any are needed).
.SH DESCRIPTION
The
.B XtConvert
function looks up the type converter registered to convert from_type
to to_type, computes any additional arguments needed, and then calls
.BR XtDirectConvert .
.B XtConvert
has been replaced by
.BR XtConvertAndStore .
.LP
The
.B XtDirectConvert
function looks in the converter cache to see if this conversion procedure
has been called with the specified arguments.
If so, it returns a descriptor for information stored in the cache;
otherwise, it calls the converter and enters the result in the cache.
.LP
Before calling the specified converter,
.B XtDirectConvert
sets the return value size to zero and the return value address to NULL.
To determine if the conversion was successful,
the client should check to_return.address for non-NULL.
.B XtDirectConvert
has been replaced by
.BR XtCallConverter .
.SH "SEE ALSO"
XtAppAddConverter(__libmansuffix__),
XtStringConversionWarning(__libmansuffix__),
XtConvertAndStore(__libmansuffix__),
XtCallConverter(__libmansuffix__)
.br
\fI\*(xT\fP
.br
\fI\*(xL\fP
