;/* Programmable Interrupt Controller (PIC) Equates
comment &
*/

#define EOI 0x20		/* EOI command for PIC	       */

#define INTA00 0x20		/* Master PIC control	       */
#define INTA01 0x21		/* Master PIC mask register    */
#define INT_MASTER_0 0x08	/* Master PIC INT number       */

#define INTB00 0xA0		/* Slave PIC control	       */
#define INTB01 0xA1		/* Slave PIC mask register     */
#define INT_SLAVE_0 0x70	/* Slave PIC INT number        */

#define INT_PROTMODE_0 0x50	/* Protected mode INT 0 number */


; /*&


EOI equ 020h			; EOI command for PIC

INTA00 equ 020h 		; Master PIC control
INTA01 equ 021h 		; Master PIC mask register
INT_MASTER_0 equ 08h		; Master PIC INT number

INTB00 equ 0A0h 		; Slave PIC control
INTB01 equ 0A1h 		; Slave PIC mask register
INT_SLAVE_0 EQU 70h		; Slave PIC INT number


INT_PROTMODE_0 equ 50h		; Protected mode INT 0 number

; */
