LISTING 6 - Illustrates the Bitstring Class
// tbitstr.cpp - Test the bitstring class
#include <iostream.h>
#include "bitstr.h"
#include "string.hpp"

main()
{
    bitstring x(21537,4), y(string("10110"));

    cout << "Initial x: " << x << endl;
    cout << "Initial y: " << y << endl;

    for (int i = 0; i <= 5; ++i)
        x.set(i);
    cout << "x: " << x << " (" << x.count()
         << " bits set)" << endl;
    cout << "x == 21567? "
         << (x == bitstring(21567,x.length())) << endl;
    cout << "x >>= 6 = " << (x >>= 6) << endl;
    cout << "x <<= 6 = " << (x <<= 6) << endl;
    cout << "x ^ 3 = " << (x ^ bitstring(3,2)) << endl;
    cout << "x | 3 = " << (x | bitstring(3,2)) << endl;
    cout << "x & 3 = " << (x & bitstring(3,2)) << endl;
    cout << "3 & x = " << (bitstring(3,2) & x) << endl;
    cout << "~x = " << (~x) << endl;

    cout << "y &= x = " << (y &= x) << endl;
    cout << "y ^= x = " << (y ^= x) << endl;
    cout << "y |= x = " << (y |= x) << endl;

    y.length(20);
    y.reset();
    for (i = 4; i <= 12; ++i)
        y.set(i);
    cout << "y: " << y << " (" << y.count()
         << " bits set)" << endl;
    cout << "x & y = " << (x & y) << endl;
    cout << "x | y = " << (x | y) << endl;
    cout << "x ^ y = " << (x ^ y) << endl;
    cout << "x != y? " << (x != y) << endl;
    cout << "x + y = " << x + y << endl;
    x += y;
    cout << "after x += y: " << x << endl;
    x.trim();
    cout << "after x.trim(): " << x << endl;

    return 0;
}

/* OUTPUT:
Initial x: 100001000010101
Initial y: 10110
x: 111111000010101 (9 bits set)
x == 21567? 1
x >>= 6 = 000000111111000
x <<= 6 = 111111000000000
x ^ 3 = 001111000000000
x | 3 = 111111000000000
x & 3 = 110000000000000
3 & x = 110000000000000
~x = 000000111111111
y &= x = 101100000000000
y ^= x = 010011000000000
y |= x = 111111000000000
y: 00001111111110000000 (9 bits set)
x & y = 00001100000000000000
x | y = 11111111111110000000
x ^ y = 11110011111110000000
x != y? 1
x + y = 11111100000000000001111111110000000
after x += y: 11111100000000000001111111110000000
after x.trim(): 1111110000000000000111111111
*/
