LISTING 3 - Illustrates the String Class
// tstr.cpp:     Test the string class

#include <iostream.h>
#include "string.hpp"

main()
{
    size_t pos;
    string s1("Hello"), s2 = ", there, you fool!  ", s3;

    // Concatenation
    cout << "s1 + s2 == " << s1+s2 << endl;
    s1 += s2;
    cout << "Now s1 == " << s1 << endl;

    // Searching
    if ((pos = s1.find("o")) != NPOS)
        cout << "find(\"o\"): " << pos << endl;
    cout << "s1.substr(4,10) == " << s1.substr(4,10) << endl;
    if ((pos = s1.find_first_of("abcde")) != NPOS)
        cout << "find_first_of(abcde): " << pos << endl;
    if ((pos = s1.find_first_not_of("abcde")) != NPOS)
        cout << "find_first_not_of(abcde): " << pos << endl;

    // Subscripting
    s3 = "This is a char* constant";
    cout << "s3[0] == " << s3.get_at(0) << endl;
    s3.put_at(3,'3');
    s3.put_at(s3.length(),'!');
    cout << "Now s3 == " << s3 << endl;

    return 0;
}

/* OUTPUT:
s1 + s2 == Hello, there, you fool!  
Now s1 == Hello, there, you fool!  
find("o"): 4
s1.substr(4,10) == o, there, 
find_first_of(abcde): 1
find_first_not_of(abcde): 0
s3[0] == T
Now s3 == Thi3 is a char* constant!
*/
