/*                         IDENTITY.C
**
** Identify the compressed file, read/write header
** in compressed file.
*/
#include <stdio.h>
#include <string.h>
#include "config.h"


static char *extension = EXTENSION;
static char *magic_header = MAGIC_HEADER;



/****** is_our_extension (char *) ******************/

int is_our_extension (char *file_extension) {
	if (!stricmp(extension, file_extension)) return 1;
	else return 0; /* if they differ */
}


char *return_extension () {
	return extension;
}


#ifdef COMPRESS
/************ write_file_header ********************/

int write_file_header() {

	/* Generate the header, i.e. the first 3 bytes
	   of compressed file: */
		putchar(magic_header[0]);
		putchar(magic_header[1]);
		if(ferror(stdout))	return WRITE_ERR;
		else return 0;
}   /* write_file_header*/

#else COMPRESS

/****** input_is_compressed() *****************/

int input_is_compressed() {	/* Check magic number */
	if ((getchar()!=(magic_header[0] & 0xFF))
		|| (getchar()!=(magic_header[1] & 0xFF)))
		return 0; /*fail */
	else return 1;
}

#endif