
       /***********************************************
       *
       *       file d:\cips\main2seg.c
       *
       *       Functions: This file contains
       *          main
       *
       *       Purpose:
       *          This is a calling program that calls
       *          the three new segmentation techniques
       *          discussed in Image Processing part 10.
       *
       *       External Calls:
       *          gin.c - get_image_name
       *          numcvrt.c - get_integer
       *                      int_convert
       *          tiff.c - read_tiff_header
       *          segment2.c - edge_region
       *                       gray_shade_region
       *                       edge_gray_shade_region
       *
       *       Modifications:
       *          5 December 1992 - created
       *
       ***********************************************/

#include "cips.h"



short the_image[ROWS][COLS];
short out_image[ROWS][COLS];

main(argc, argv)
   int argc;
   char *argv[];
{

   char     name[80], name2[80], low_high[80], type[80];
   float    percent;
   int      count, i, ie, il, j, le, length, ll,
            looking = 1, lw, width;
   short    value,  value2, value3, 
            value4, value5, value6;
   struct   tiff_header_struct image_header;
   my_clear_text_screen();

       /***********************************************
       *
       *       Interpret the command line parameters.
       *
       ************************************************/

   if(argc < 4){
    printf(
    "\n\nNot enough parameters:"
     "\n"
     "\n usage: main2seg in-file out-file type"
     " [values ...]"
     "\n"
     "\n   recall type: Edge-region edge-gray-grow (C)"
     " Gray-shade-grow"
     "\n"
    "\n   main2seg in-file out-file C percent "
    "edge-type "
    "\n            min-area max-area diff set-value erode"
    "\n   main2seg in-file out-file E percent "
    "edge-type "
    "\n            min-area max-area diff set-value erode"
    "\n   main2seg in-file out-file G diff "
    "min-area max-area"
    "\n"
    "\n");
    exit(0);
   }

   strcpy(name,  argv[1]);
   strcpy(name2, argv[2]);
   strcpy(type,  argv[3]);
   if(type[0] == 'a' || type[0] == 'A'  ||
      type[0] == 'c' || type[0] == 'C'  ||
      type[0] == 'e' || type[0] == 'E'){
      percent = atof(argv[4]);
      value   = atoi(argv[5]);
      value2  = atoi(argv[6]);
      value3  = atoi(argv[7]);
      value4  = atoi(argv[8]);
      value5  = atoi(argv[9]);
      value6  = atoi(argv[10]);
    }
   else{
      value  = atoi(argv[4]);
      value2 = atoi(argv[5]);
      value3 = atoi(argv[6]);
   }

   il = 1;
   ie = 1;
   ll = ROWS+1;
   le = COLS+1;

       /******************************************
       *
       *  Read the input image header and setup
       *  the looping counters.
       *
       *******************************************/

   read_tiff_header(name, &image_header);

   length = (ROWS-10 + image_header.image_length)/ROWS;
   width  = (COLS-10 + image_header.image_width)/COLS;
   count  = 1;
   lw     = length*width;
   printf("\nlength=%d  width=%d", length, width);


   if(type[0] == 'e'  || type[0] == 'E'){
      for(i=0; i<length; i++){
         for(j=0; j<width; j++){
            printf("\nrunning %d of %d", count, lw);
            count++;
            edge_region(name, name2, the_image, 
                        out_image, il+i*ROWS, 
                        ie+j*COLS, ll+i*ROWS,
                        le+j*COLS, value, value2, 
                        value3, value4, percent, 
                        value5, value6);
         }  /* ends loop over j */
      }  /* ends loop over i */
   }  /* ends edge_region */



   if(type[0] == 'g'  || type[0] == 'G'){
      for(i=0; i<length; i++){
         for(j=0; j<width; j++){
            printf("\nrunning %d of %d", count, lw);
            count++;
            gray_shade_region(name, name2, the_image,
                              out_image, il+i*ROWS,
                              ie+j*COLS, ll+i*ROWS,
                              le+j*COLS, value,
                              value2, value3);
         }  /* ends loop over j */
      }  /* ends loop over i */
   }  /* ends gray_shade_region */



   if(type[0] == 'c'  || type[0] == 'C'){
      for(i=0; i<length; i++){
         for(j=0; j<width; j++){
            printf("\nrunning %d of %d", count, lw);
            count++;
            edge_gray_shade_region(name, name2, 
                     the_image, out_image, il+i*ROWS, 
                     ie+j*COLS, ll+i*ROWS, le+j*COLS,
                     value, value2, value3, value4, 
                     percent, value5, value6);
         }  /* ends loop over j */
      }  /* ends loop over i */
   }  /* ends edge_gray_shade_region */

}  /* ends main  */