

   /***********************************************
   *
   *   file d:\cips\mainas.c
   *
   *   Functions: This file contains
   *      main
   *
   *   Purpose:
   *      This file contains the main calling
   *      routine in an image addition and subtraction
   *      program.
   *
   *   External Calls:
   *      gin.c - get_image_name
   *      numcvrt.c - get_integer
   *                  int_convert
   *      tiff.c - read_tiff_header
   *      addsub.c - add_image
   *                 subtract_image
   *
   *   Modifications:
   *      1 April 1992 - created
   *
   *************************************************/

#include "cips.h"



short the_image[ROWS][COLS];
short out_image[ROWS][COLS];

main(argc, argv)
   int argc;
   char *argv[];
{

   char     name[80], name2[80], name3[80];
   int      count, i, j, length, lw,
            type, width,
            il1, ie1, ll1, le1,
            il2, ie2, ll2, le2,
            il3, ie3, ll3, le3;
   struct   tiff_header_struct image_header;
   my_clear_text_screen();

       /******************************************
       *
       *  Interpret the command line parameters.
       *
       *******************************************/

   if(argc < 5 || argc > 5){
    printf(
     "\n"
     "\n usage: mainas in1-file in2-file "
     "out_file add-subtract"
     "\n"
     "\n   recall add-subtract a=add s=subtract\n");
    exit(0);
   }

   strcpy(name, argv[1]);
   strcpy(name2, argv[2]);
   strcpy(name3, argv[3]);

   il1 = 1;
   ie1 = 1;
   ll1 = ROWS+1;
   le1 = COLS+1;

   il2 = 1;
   ie2 = 1;
   ll2 = ROWS+1;
   le2 = COLS+1;

   il3 = 1;
   ie3 = 1;
   ll3 = ROWS+1;
   le3 = COLS+1;

       /******************************************
       *
       *  Read the input image header and setup
       *  the looping counters.
       *
       *  If high or low pass filtering, setup
       *  the filter mask array.
       *
       *******************************************/

   read_tiff_header(name, &image_header);

   length = (ROWS-10 + image_header.image_length)/ROWS;
   width  = (COLS-10 + image_header.image_width)/COLS;
   count  = 1;
   lw     = length*width;
   printf("\nlength=%d  width=%d", length, width);

       /********************************************
       *
       *   Loop over the input images and either
       *   add or subtract them.
       *
       ********************************************/

   for(i=0; i<length; i++){
      for(j=0; j<width; j++){
         printf("\nrunning %d of %d", count, lw);
         count++;

         if(argv[4][0] == 'a' || argv[4][0] == 'A')
            add_image_array(name, name2, name3,
               the_image, out_image,
               il1+i*ROWS, ie1+j*COLS, 
               ll1+i*ROWS, le1+j*COLS,
               il2+i*ROWS, ie2+j*COLS, 
               ll2+i*ROWS, le2+j*COLS,
               il3+i*ROWS, ie3+j*COLS, 
               ll3+i*ROWS, le3+j*COLS);

         if(argv[4][0] == 's' || argv[4][0] == 'S')
            subtract_image_array(name, name2, name3,
               the_image, out_image,
               il1+i*ROWS, ie1+j*COLS, 
               ll1+i*ROWS, le1+j*COLS,
               il2+i*ROWS, ie2+j*COLS, 
               ll2+i*ROWS, le2+j*COLS,
               il3+i*ROWS, ie3+j*COLS, 
               ll3+i*ROWS, le3+j*COLS);

      }  /* ends loop over j */
   }  /* ends loop over i */
}  /* ends main  */
