
    /***********************************************
    *
    *    file d:\cips\maincp.c
    *
    *    Functions: This file contains
    *       main
    *
    *    Purpose:
    *       This file contains the main calling
    *       routine for a program which 
    *       cuts a piece from one image and pastes
    *       it into another.
    *
    *    External Calls:
    *       cutp.c - cut_image_piece
    *                paste_image_piece
    *       gpcips.c - my_clear_text_screen
    *
    *    Modifications:
    *       8 April 1992 - created
    *
    *************************************************/

#include "cips.h"



short the_image[ROWS][COLS];
short out_image[ROWS][COLS];

main(argc, argv)
   int  argc;
   char *argv[];
{

   char     name[80], name2[80];
   int      il1, ie1, ll1, le1,
            il2, ie2, ll2, le2;

   my_clear_text_screen();

       /******************************************
       *
       *  Interpret the command line parameters.
       *
       *******************************************/

   if(argc < 3 || argc > 7){
    printf(
     "\n"
     "\n usage: maincp in-file out_file "
     "[in-il in-ie out-il out-ie]"
     "\n"
     "\n If you do not specify the il's ie's, "
     "they are set to 1."
     "\n The le's le's equal il+ROWS ie+COLS."
     "\n");
    exit(0);
   }

   strcpy(name, argv[1]);
   strcpy(name2, argv[2]);

   if(argc > 3 || argc <= 7){
      il1 = atoi(argv[3]);
      ie1 = atoi(argv[4]);
      il2 = atoi(argv[5]);
      ie2 = atoi(argv[6]);
   }
   else{
      il1 = 1;
      ie1 = 1;
      il2 = 1;
      ie2 = 1;
   }

   ll1 = il1 + ROWS;
   le1 = ie1 + COLS;
   ll2 = il2 + ROWS;
   le2 = ie2 + COLS;

   create_file_if_needed(name, name2, out_image);

       /*************************
       *
       *   Cut and paste
       *
       **************************/

   printf("\nin  file il=%d ie=%d ll=%d le=%d",
          il1, ie1, ll1, le1);
   printf("\nout file il=%d ie=%d ll=%d le=%d",
          il2, ie2, ll2, le2);
   cut_image_piece(name, the_image, il1, ie1, ll1, le1);
   paste_image_piece(name2, name, the_image, out_image, 
                     il2, ie2, ll2, le2);

}  /* ends main */
