

    /********************************************
    *
    *    file d:\cips\warp.c
    *
    *    Functions: This file contains
    *       main
    *
    *    Purpose:
    *       This file contains the main calling
    *       routine for warping subroutines.
    *
    *    External Calls:
    *       gin.c - get_image_name
    *       tiff.c - read_tiff_header
    *       warpsubs.c - warp
    *                    object_warp
    *
    *    Modifications:
    *       26 October 1993 - created
    *
    ********************************************/

#include "cips.h"


short the_image[ROWS][COLS];
short out_image[ROWS][COLS];

main(argc, argv)
   int argc;
   char *argv[];
{

   char   name[80], name2[80], type[80];
   float  theta, x_stretch, y_stretch,
          x_cross, y_cross;
   int    bilinear, count, i, ie, il, j, le,
          length, ll, width,
          x1, x2, x3, x4, y1, y2, y3, y4;
   int    x_control, y_control;
   short  m, n, x_displace, y_displace;
   struct tiff_header_struct image_header;

   my_clear_text_screen();


      /*************************************
      *
      *   This program will use a different
      *   command line for each type of
      *   call.
      *
      *   Print a usage statement that
      *   gives an example of each type
      *   of call.
      *
      *************************************/

   if(argc < 7){
    printf("\n\nNot enough parameters:");
    printf("\n");
    printf("\n   Two Operations: ");
    printf("\n      warp      object-warp");
    printf("\n\n   Examples:");
    printf("\n");
    printf("\n   warp in out warp x-control ");
    printf("y-control il ie bilinear (1 or 0)");
    printf("\n");
    printf("\n   warp in out object-warp x1 y1");
    printf(" x2 y2 x3 y3 x4 y4 il ie ");
    printf("bilinear (1 or 0)");
    printf("\n");
    exit(0);
   }

      /*************************************
      *
      *   Interpret the command line
      *   depending on the type of call.
      *
      *************************************/

   if(strncmp(argv[3], "warp", 3) == 0){
      strcpy(name,  argv[1]);
      strcpy(name2, argv[2]);
      strcpy(type,  argv[3]);
      x_control = atoi(argv[4]);
      y_control = atoi(argv[5]);
      il        = atoi(argv[6]);
      ie        = atoi(argv[7]);
      bilinear  = atoi(argv[8]);
   }

   if(strncmp(argv[3], "object-warp", 3) == 0){
      strcpy(name,  argv[1]);
      strcpy(name2, argv[2]);
      strcpy(type,  argv[3]);
      x1        = atoi(argv[4]);
      y1        = atoi(argv[5]);
      x2        = atoi(argv[6]);
      y2        = atoi(argv[7]);
      x3        = atoi(argv[8]);
      y3        = atoi(argv[9]);
      x4        = atoi(argv[10]);
      y4        = atoi(argv[11]);
      il        = atoi(argv[12]);
      ie        = atoi(argv[13]);
      bilinear  = atoi(argv[14]);
   }

   il = 1;
   ie = 1;
   ll = ROWS+1;
   le = COLS+1;

   read_tiff_header(name, &image_header);

   length = (ROWS-10 + image_header.image_length)/ROWS;
   width  = (COLS-10 +image_header.image_width)/COLS;
   count  = 1;
   printf("\nlength=%d  width=%d", length, width);

      /*************************************
      *
      *   Call the routines
      *
      *************************************/

   if(strncmp(type, "warp", 3) == 0){
      il = atoi(argv[6]);
      ll = il+ROWS;
      ie = atoi(argv[7]);
      le = ie+COLS;
      warp(name, name2, the_image, out_image,
           il, ie, ll, le,
           x_control, y_control,
           bilinear);
   }  /* ends if */



   if(strncmp(argv[3], "object-warp", 3) == 0){
      il = atoi(argv[12]);
      ll = il+ROWS;
      ie = atoi(argv[13]);
      le = ie+COLS;
      object_warp(name, name2, the_image, out_image,
                  il, ie, ll, le, 
                  x1, y1, x2, y2, 
              x3, y3, x4, y4,
                  bilinear);
    }   /* ends if */

}  /* ends main  */
