

/* Listing 10: 3D Sparse Array Program. */

#include "aa.h"

typedef struct { long i; long j; long k; } INDEX;
static INDEX t; /* temporary used in SPARSE macro */
#define SPARSE(x,y,z) (*(t.i=x,t.j=y,t.k=z, \
		      (double *)aa_addr(sparse_id,&t)))
main()
{
  unsigned int i,j,k;
  AA *sparse_id=aa_create(BINARY_KEY,sizeof(INDEX),
			  sizeof(double),500,NULL);
  for (i=0; i<=10000; i+=2000)
    for (j=0; j<=10000; j+=2000)
      for (k=0; k<=10000; k+=2000) {
	SPARSE(i,j,k)=(i+j+k) * 0.0001;
	printf("SPARSE(%5d,%5d,%5d)\t=\t%f\n",
	       i,j,k,SPARSE(i,j,k));
      }
}
