[LISTING 2]
###############################################################################
#
#  makefile for embedded "hello.c" application.
#
#  MSC 7.0 Compiler Switches
#
#  /c     - compile only, no link step
#  /AC    - Specifies compact memory model
#  /FPi87 - Generate in-line x87 code (but our code uses no fp instructions)
#  /Gs    - Remove Stack Overflow Checks
#  /Ois   - Optimize for code size over execution time.
#           The 'i' allows certain functions (inp, outp, etc.) to be 
#           generated inline.  Just say NO to unsafe optimization options!
#  /W3    - Almost maximum warning level
#  /Fc    - Generate mixed C/asm listing to specified file
#
#
#  LINKING
#
#  Our code doesn't use any floating point variables at all, so
#  it shouldn't need any floating point support.  The -FPi87 option
#  is used, and the clibc7 library is used just to make sure that
#  no floating-point emulator code is included in the build.
#
###############################################################################

CFLAGS  = /c /AC /Gs /Ois /FPi87 /W3 

.c.obj:
   cl $(CFLAGS) -Fc$*.cod $*.c

.asm.obj:
   masm /MX $*.asm,$*.obj,$*.lst;

default:    embed.bin

#
# Source to be compiled or assembled.
#

hello.obj: hello.c stdio.h

stdio.obj: stdio.c stdio.h

startup.obj: startup.asm

#
# Link step -- NOTE: startup MUST be linked first.
#

embed.exe: startup.obj hello.obj stdio.obj
   link startup hello stdio, embed.exe, embed.map /NOI/MAP/NOPACKCODE;

#
# In this step, we use exe2bin as a locator.  It will ask for a
# segment base to use for fix-ups.  We specify the segment address
# in RAM where the data will be during execution.  The startup
# code will use the value specified here to decide where to copy
# the data before beginning execution.  Value specified is in hex.
#

embed.fix: embed.exe
   exe2bin embed.exe embed.fix < <<
40
<<

#
# This step uses debug to insert code into the reset vector.
# Note that debug will load the first byte at offset 100h instead
# of offset 0.  The instructions inserted are CLI, CLD, and JMP F800:0
#

embed.bin: embed.fix
   debug embed.fix < <<
n embed.bin
r cx
8000
e 80f0 fa fc ea 00 00 00 f8 00 00 00 00 00 00 00 00 00
w
q
<<

#
# end of makefile
#

