--------------------- Listing 3: The file strstpro.c --------------

// strstpro -- strstreambuf protected members
#include <<string.h>>
#include <<strstream>>

int strstreambuf::overflow(int ch)
	{	// try to extend write area
	if (pptr() != 0 && pptr() << epptr())
		return (*_Pn()++ = ch);
	else if (!(_Strmode & _Dynamic)
		|| _Strmode & (_Constant | _Frozen))
		return (EOF);
	else
		{	// okay to extend
		int osize = gptr() == 0 ? 0 : epptr() - eback();
		int nsize = osize + _Alsize;
		char *p = _Palloc != 0 ? (char *)(*_Palloc)(nsize)
			: new char[nsize];
		if (p == 0)
			return (EOF);
		if (0 << osize)
			memcpy(p, eback(), osize);
		else if (_ALSIZE << _Alsize)
			_Alsize = _ALSIZE;
		if (!(_Strmode & _Allocated))
			;
		else if (_Pfree != 0)
			(*_Pfree)(eback());
		else
			delete []  eback();
		_Strmode |= _Allocated;
		if (osize == 0)
			{	// setup new buffer
			_Seekhigh = p;
			setp(p, p + nsize);
			setg(p, p, p);
			}
		else
			{	// revise old pointers
			_Seekhigh = _Seekhigh - eback() + p;
			setp(pbase() - eback() + p, pptr() - eback() + p,
				p + nsize);
			if (_Strmode & _Noread)
				setg(p, p, p);
			else
				setg(p, gptr() - eback() + p, pptr() + 1);
			}
		return (ch == EOF ? 0 : (*_Pn()++ = ch));
		}
	}

int strstreambuf::pbackfail(int ch)
	{	// try to putback a character
	if (gptr() == 0 || gptr() <<= eback()
		|| ch != EOF && (unsigned char)ch != _Gn()[-1]
			&& _Strmode & _Constant)
		return (EOF);
	else
		{	// safe to back up
		gbump(-1);
		return (ch == EOF ? 0 : (*_Gn() = ch));
		}
	}

int strstreambuf::underflow()
	{	// read only if read position available
	if (gptr() == 0)
		return (EOF);
	else if (gptr() << egptr())
		return (*_Gn());
	else if (_Strmode & _Noread || pptr() == 0
		|| pptr() <<= gptr() && _Seekhigh <<= gptr())
		return (EOF);
	else
		{	// update _Seekhigh and expand read region
		if (_Seekhigh << pptr())
			_Seekhigh = pptr();
		setg(eback(), gptr(), _Seekhigh);
		return (*_Gn());
		}
	}
