'Types used internally by Finger to talk to NWCALLS.DLL
'and receive the input

Global Const OT_WILD = &HFFFF
Global Const OT_UNKNOWN = &H0
Global Const OT_USER = &H100
Global Const OT_USER_GROUP = &H200
Global Const OT_PRINT_QUEUE = &H300
Global Const OT_FILE_SERVER = &H400
Global Const OT_JOB_SERVER = &H500
Global Const OT_GATEWAY = &H600
Global Const OT_PRINT_SERVER = &H700
Global Const OT_ARCHIVE_QUEUE = &H800
Global Const OT_ARCHIVE_SERVER = &H900
Global Const OT_JOB_QUEUE = &HA00

Global Const MAX_EXCLUSIONS = 80
Global Const MAX_RETRIES = 3

Global Const IPX_SPX_COMPONENT = 0
Global Const BRIDGE_DRIVER_COMPONENT = 1
Global Const SHELL_DRIVER_COMPONENT = 2
Global Const SHELL_COMPONENT = 3
Global Const VAP_SHELL_COMPONENT = 4
Global Const BRIDGE_COMPONENT = 5
Global Const FILE_SERVER_COMPONENT = 6
Global Const NONDEDICATED_IPX_SPX_COMPONENT = 7
Global Const IPX_ONLY = 8
Global Const GNMA_DOS_COMPONENT = 9
Global Const GNMA_OS2_COMPONENT = 10
Global Const NWLITE_SERVER_COMPONENT = 11
Global Const NWLITE_CACHE_COMPONENT = 12

Type USER_INFO
    connNumber As Integer
    objectName As String * 48
    objectType As Integer
    objectID As Long
    loginTime As String * 7
End Type

Type NWInetAddr
    network As String * 4
    node As String * 6
    socket As Integer
    conntype As Integer
End Type

Type NodeAddress
    node As String * 6
End Type

Type IPXAddress
    network As String * 4
    node As String * 6
    socket As String * 2
End Type

Type IPXHeader
    checkSum As Integer
    length As Integer
    transportControl As Integer
    packetType As String * 1
    destination As IPXAddress
    source As IPXAddress
End Type

Type ExclusionListStruct
    NodeAddress As String * 6
End Type

Type ExclusionPacketStructure
    numberOfExclusions As String * 1
    exclusionList(MAX_EXCLUSIONS) As ExclusionListStruct
End Type
                    
Type IPXReplyStruct
    majorVersion  As String * 1
    minorVersion As String * 1
    spxDiagnosticSocket As String * 2
    componentList As String * 55
    'componentType As String * 54
End Type

Type AllResponseData
    completionCode As String * 1
    intervalMarker As Long
End Type

Type NameTableStruct
    name As String * 48
End Type

Type ServerNameTableStruct
    nameTable(8) As NameTableStruct
End Type

Type AddressTableStruct
    serverUsed As String * 1
    orderNumber As String * 1
    serverNetwork As String * 4
    serverNode As String * 6
    serverSocket As String * 2
    receivedTimeOut As Integer
    immediateNode As String * 6
    sequenceNumber As String * 1
    connectionNumber As String * 1
    connectionOK As String * 1
    maximumTimeOut As Integer
    reserved As String * 5
End Type

Type ServerAddressTableStruct
    addressTable(8) As AddressTableStruct
End Type

Type PrimaryServerStruct
    number As String * 1
End Type

'Global variables used with Finger
Global nwConn As Integer
Global netWareUsers() As USER_INFO
Global newUserName As String
Global newPassword As String

'Global variables used with Ping
Global HoldRequest As ExclusionPacketStructure
Global HoldReply As IPXReplyStruct
Global NodeList(MAX_EXCLUSIONS) As NodeAddress
Global NodeCount As Integer
Global newNodes As Integer
Global broadcastAddress As IPXAddress

'NWCALLS.DLL function prototypes
Declare Function NWGetFileServerName Lib "NWCALLS.DLL" (ByVal conn As Integer, ByVal serverName As String) As Integer
Declare Function NWGetConnectionHandle Lib "NWCALLS.DLL" (ByVal serverName As String, ByVal reserver1 As Integer, conn As Integer, reserved2 As Any) As Integer
Declare Function NWCallsInit Lib "NWCALLS.DLL" (ByVal in&, ByVal out&) As Integer
Declare Function NWGetFileServerInformation Lib "NWCALLS.DLL" (ByVal conn As Integer, serverName As Any, majVer As Any, minVer As Any, rev As Any, maxConn As Any, maxConnUsed As Any, maxConnsInuse As Any, numVol As Any, sft As Any, tts As Any) As Integer
Declare Function NWGetConnectionInformation Lib "NWCALLS.DLL" (ByVal conn As Integer, ByVal connNumber As Integer, objectName As Any, objectType As Any, objectID As Any, loginTime As Any) As Integer
Declare Function NWGetInetAddr Lib "NWCALLS.DLL" (ByVal conn As Integer, ByVal connNumber As Integer, inetAddress As NWInetAddr) As Integer
Declare Function NWGetConnectionNumber Lib "NWCALLS.DLL" (ByVal conn As Integer, connNumber As Integer) As Integer
Declare Function NWGetConnectionList Lib "NWCALLS.DLL" (ByVal connMode As Integer, connListBuffer As Any, ByVal connListSize As Integer, numConnections As Integer) As Integer
Declare Function NWAttachToFileServer Lib "NWCALLS.DLL" (ByVal serverName As String, ByVal scopeFlag As Integer, newConnID As Integer) As Integer
Declare Function NWDetachFromFileServer Lib "NWCALLS.DLL" (ByVal newConnID As Integer) As Integer
Declare Function NWLoginToFileServer Lib "NWCALLS.DLL" (ByVal conn As Integer, ByVal objectName As String, ByVal objectType As Integer, ByVal Password As String) As Integer
Declare Function NWReadPropertyValue Lib "NWCALLS.DLL" (ByVal conn As Integer, ByVal objectName As String, ByVal objectType As Integer, ByVal propertyName As String, ByVal dataSetIndex As Integer, ByVal dataBuffer As String, moreFlag As Integer, propertyFlags As Integer) As Integer

'NWIPXSPX.DLL function prototypes
Declare Function FindComponentOffset Lib "NWIPXSPX.DLL" (ByVal componentList As String, ByVal componentID As Integer) As Integer
Declare Function IPXGetIntervalMarker Lib "NWIPXSPX.DLL" (IPXTaskID As Long) As Integer
Declare Function BeginDiagnostics Lib "NWIPXSPX.DLL" (address As IPXAddress, connectionID As Integer, ByVal componentList As String) As Integer
Declare Function EndDiagnostics Lib "NWIPXSPX.DLL" (ByVal connectionID As Integer) As Integer
Declare Function GetServerNameTable Lib "NWIPXSPX.DLL" (ByVal connectionID As Integer, ByVal componentNumber As Integer, response As AllResponseData, responseData As ServerNameTableStruct) As Integer
Declare Function GetServerAddressTable Lib "NWIPXSPX.DLL" (ByVal connectionID As Integer, ByVal componentNumber As Integer, response As AllResponseData, responseData As ServerAddressTableStruct) As Integer
Declare Function GetPrimaryServerNumber Lib "NWIPXSPX.DLL" (ByVal connectionID As Integer, ByVal componentNumber As Integer, response As AllResponseData, responseData As PrimaryServerStruct) As Integer


