/*
 *  passthru.c - program to pass files directly to Windows printer.
 *
 *  This file simply supplies the user interface. It uses a dialog
 *  box as the main window, which greatly simplifies things.
 */

#include "passthru.h"
#include <stdio.h>


/*
 *  filefind.c - a simple filename routine.
 */

#include <windows.h>

BOOL    SimpleGetOpenFileName(HWND ParentWindow,
    char FAR *FileName, size_t MaxPath, char FAR *Filter)
    {
    OPENFILENAME    DialogArgs;

    if(Filter == NULL)
        Filter  = "All file types\0*.*";
    *FileName               = '\0';
    memset(&DialogArgs, 0, sizeof(DialogArgs));
    DialogArgs.lStructSize  = sizeof(DialogArgs);
    DialogArgs.hwndOwner    = ParentWindow;
    DialogArgs.lpstrFilter  = Filter;
    DialogArgs.nFilterIndex = 1;
    DialogArgs.lpstrFile    = FileName;
    DialogArgs.nMaxFile     = MaxPath;
    DialogArgs.Flags        = OFN_FILEMUSTEXIST | OFN_SHOWHELP;

    return GetOpenFileName(&DialogArgs);
    }


HINSTANCE   ThisInstance;   // ubiquitous instance handle.
TPrinter    Printer;        // For talking to printer.

#ifdef __BORLANDC__
    #pragma argsused
#endif
int PASCAL WinMain(HINSTANCE Me, HINSTANCE Previous,
		     LPSTR lpszCmdLine, int nCmdShow)
    {
    ThisInstance    = Me;
    DialogBox(Me, "PassThru", NULL, (DLGPROC)DlgProc);
    return 0;
    }

// Display current printer in a static text control
void    DisplayPrinter(TPrinter *Printer, HWND Dialog)
    {
    char    Device[128];
    char    Driver[128];
    char    Port[128];

    Printer->GetDevice(Device, sizeof(Device));
    Printer->GetDriver(Driver, sizeof(Driver));
    Printer->GetPort(Port, sizeof(Port));

    char    Message[256];
    sprintf(Message, "%s (%s) on %s", Device, Driver, Port);
    SetDlgItemText(Dialog, ID_CURRENTPRINTER_STATIC, Message);
    }


#ifdef __BORLANDC__
    #pragma argsused
#endif
BOOL CALLBACK _export DlgProc(HWND Dialog, UINT Message,
                             WPARAM Param1, LPARAM Param2)
    {
    if(Message == WM_INITDIALOG)
        {
        DisplayPrinter(&Printer, Dialog);
        return TRUE;
        }
    else if(Message == WM_COMMAND)
        if(Param1 == IDOK || Param1 == IDCANCEL) {
            EndDialog(Dialog, 0);
            return TRUE;
            }
        else if(Param1 == ID_PRINT_BUTTON)
            {
            char    Filename[128];
            Filename[0] = '\0';
            GetDlgItemText(Dialog, ID_FILENAME_EDIT,
                                Filename, sizeof(Filename));
            char    Prefix[128];
            Prefix[0] = '\0';
            GetDlgItemText(Dialog, ID_PREFIX_EDIT,
                                    Prefix, sizeof(Prefix));
            if(Filename[0] == '\0')
                MessageBox(Dialog, "Select a file first",
                             "PassThru", MB_OK|MB_ICONHAND);
            else
                PrintFile(&Printer, Dialog, Filename,
                                                    Prefix);
            return TRUE;
            }
        else if(Param1 == ID_SELECTPRINTER_BUTTON)
            {
            Printer.SetupDialog(Dialog);
            DisplayPrinter(&Printer, Dialog);
            return TRUE;
            }
        else if(Param1 == ID_BROWSE_BUTTON)
            {
            char    Filename[128];
            Filename[0] = '\0'; // trust no one
            GetDlgItemText(Dialog, ID_FILENAME_EDIT,
                                Filename, sizeof(Filename));
                
            if(SimpleGetOpenFileName(Dialog, Filename,
                                          sizeof(Filename)))
                SetDlgItemText(Dialog, ID_FILENAME_EDIT, Filename);
            return TRUE;
            }
    return FALSE;
    }


