/*
 *  print.c - code to handle printing a file.
 */

#include <stdio.h>
#include <string.h>
#include "passthru.h"

#define PRINTDRIVER /* to enable definitions in print.h */
#include <print.h>

const int BUFFER_SIZE = 4096;

int     PrintFile(TPrinter *Printer, HWND ParentWindow,
                               char *Filename, char *Prefix)
    {
    HDC     PrinterContext;
    HPJOB   Job;
    char   *Buffer = new char[BUFFER_SIZE+1];

    if(Buffer == NULL)
        {
        MessageBox(ParentWindow,
                        "Insufficient memory for file copy",
                             "PassThru", MB_OK|MB_ICONSTOP);
        return FALSE;
        }
    FILE   *InputFile = fopen(Filename, "rb");
    if(InputFile == NULL)
        {
        char    Message[128];
        sprintf(Message,
             "Can't open file '%s' for reading.", Filename);
        MessageBox(ParentWindow, Message, "PassThru",
                                         MB_OK|MB_ICONSTOP);
        delete Buffer;
        return FALSE;
        }
    PrinterContext  = Printer->CreateDC();
    assert(PrinterContext != NULL);
    char    Port[64];
    Printer->GetPort(Port, sizeof(Port));
    Job = OpenJob(Port, Filename, (HPJOB)PrinterContext);
    StartSpoolPage(Job);

    // change to hourglass cursor, since we may hog CPU
    HCURSOR OldCursor =SetCursor(LoadCursor(NULL,IDC_WAIT));
    // write out prefix string
    WriteSpool(Job, Prefix, strlen(Prefix));
    size_t NBytes = 0;
    for(;;)
        {
        NBytes  = fread(Buffer, 1, BUFFER_SIZE, InputFile);
        if(NBytes > 0)
            WriteSpool(Job, Buffer, NBytes);
        else
            break;
        }
    SetCursor(OldCursor);
    EndSpoolPage(Job);
    CloseJob(Job);
    DeleteDC(PrinterContext);
    fclose(InputFile);
    delete Buffer;
    return TRUE;
    }
